/*
 * Decompiled with CFR 0.152.
 */
package dev.ikm.tinkar.common.id.impl;

import dev.ikm.tinkar.common.id.PublicId;
import dev.ikm.tinkar.common.id.VertexId;
import dev.ikm.tinkar.common.id.impl.PublicId2;
import dev.ikm.tinkar.common.id.impl.PublicId3;
import dev.ikm.tinkar.common.id.impl.PublicIdA;
import java.util.Arrays;
import java.util.UUID;
import java.util.function.LongConsumer;

public class PublicId1
extends PublicIdA
implements VertexId {
    protected final long msb;
    protected final long lsb;

    public PublicId1(UUID uuid) {
        this.msb = uuid.getMostSignificantBits();
        this.lsb = uuid.getLeastSignificantBits();
    }

    public PublicId1(long msb, long lsb) {
        this.msb = msb;
        this.lsb = lsb;
    }

    @Override
    public int uuidCount() {
        return 1;
    }

    @Override
    public long mostSignificantBits() {
        return this.msb;
    }

    @Override
    public long leastSignificantBits() {
        return this.lsb;
    }

    @Override
    public UUID[] asUuidArray() {
        return new UUID[]{new UUID(this.msb, this.lsb)};
    }

    @Override
    public void forEach(LongConsumer consumer) {
        consumer.accept(this.msb);
        consumer.accept(this.lsb);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof PublicId) {
            PublicId publicId = (PublicId)o;
            if (o instanceof PublicId1) {
                PublicId1 publicId1 = (PublicId1)o;
                return this.msb == publicId1.msb && this.lsb == publicId1.lsb;
            }
            if (o instanceof PublicId2) {
                PublicId2 publicId2 = (PublicId2)o;
                return this.msb == publicId2.msb && this.lsb == publicId2.lsb || this.msb == publicId2.msb2 && this.lsb == publicId2.lsb2;
            }
            if (o instanceof PublicId3) {
                PublicId3 publicId3 = (PublicId3)o;
                return this.msb == publicId3.msb && this.lsb == publicId3.lsb || this.msb == publicId3.msb2 && this.lsb == publicId3.lsb2 || this.msb == publicId3.msb3 && this.lsb == publicId3.lsb3;
            }
            UUID[] thisUuids = this.asUuidArray();
            return Arrays.stream(publicId.asUuidArray()).anyMatch(uuid -> {
                for (UUID thisUuid : thisUuids) {
                    if (!uuid.equals(thisUuid)) continue;
                    return true;
                }
                return false;
            });
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(new long[]{this.msb, this.lsb});
    }
}

