/*
 * Decompiled with CFR 0.152.
 */
package dev.ikm.tinkar.common.id.impl;

import dev.ikm.tinkar.common.id.PublicId;
import dev.ikm.tinkar.common.id.impl.PublicId1;
import dev.ikm.tinkar.common.id.impl.PublicId3;
import dev.ikm.tinkar.common.id.impl.PublicIdA;
import java.util.Arrays;
import java.util.UUID;
import java.util.function.LongConsumer;

public class PublicId2
extends PublicIdA {
    protected final long msb;
    protected final long lsb;
    protected final long msb2;
    protected final long lsb2;

    public PublicId2(UUID uuid, UUID uuid2) {
        this.msb = uuid.getMostSignificantBits();
        this.lsb = uuid.getLeastSignificantBits();
        this.msb2 = uuid2.getMostSignificantBits();
        this.lsb2 = uuid2.getLeastSignificantBits();
    }

    public PublicId2(long msb, long lsb, long msb2, long lsb2) {
        this.msb = msb;
        this.lsb = lsb;
        this.msb2 = msb2;
        this.lsb2 = lsb2;
    }

    @Override
    public int uuidCount() {
        return 2;
    }

    @Override
    public void forEach(LongConsumer consumer) {
        consumer.accept(this.msb);
        consumer.accept(this.lsb);
        consumer.accept(this.msb2);
        consumer.accept(this.lsb2);
    }

    @Override
    public UUID[] asUuidArray() {
        return new UUID[]{new UUID(this.msb, this.lsb), new UUID(this.msb2, this.lsb2)};
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof PublicId) {
            PublicId publicId = (PublicId)o;
            if (o instanceof PublicId1) {
                PublicId1 publicId1 = (PublicId1)o;
                return publicId1.equals(this);
            }
            if (o instanceof PublicId2) {
                PublicId2 publicId2 = (PublicId2)o;
                return this.msb == publicId2.msb && this.lsb == publicId2.lsb || this.msb == publicId2.msb2 && this.lsb == publicId2.lsb2 || this.msb2 == publicId2.msb && this.lsb2 == publicId2.lsb || this.msb2 == publicId2.msb2 && this.lsb2 == publicId2.lsb2;
            }
            if (o instanceof PublicId3) {
                PublicId3 publicId3 = (PublicId3)o;
                return this.msb == publicId3.msb && this.lsb == publicId3.lsb || this.msb == publicId3.msb2 && this.lsb == publicId3.lsb2 || this.msb == publicId3.msb3 && this.lsb == publicId3.lsb3 || this.msb2 == publicId3.msb && this.lsb2 == publicId3.lsb || this.msb2 == publicId3.msb2 && this.lsb2 == publicId3.lsb2 || this.msb2 == publicId3.msb3 && this.lsb2 == publicId3.lsb3;
            }
            UUID[] thisUuids = this.asUuidArray();
            return Arrays.stream(publicId.asUuidArray()).anyMatch(uuid -> {
                for (UUID thisUuid : thisUuids) {
                    if (!uuid.equals(thisUuid)) continue;
                    return true;
                }
                return false;
            });
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(new long[]{this.msb, this.lsb, this.msb2, this.lsb2});
    }
}

