/*
 * Decompiled with CFR 0.152.
 */
package dev.ikm.tinkar.common.id.impl;

import dev.ikm.tinkar.common.id.PublicId;
import dev.ikm.tinkar.common.id.PublicIdCollection;
import dev.ikm.tinkar.common.id.PublicIdList;
import dev.ikm.tinkar.common.id.PublicIdSet;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class PublicIdCollections {
    static final int SALT;
    static final int EXPAND_FACTOR = 2;

    private PublicIdCollections() {
    }

    static UnsupportedOperationException uoe() {
        return new UnsupportedOperationException();
    }

    static <E> List<E> listCopy(Collection<? extends E> coll) {
        if (coll instanceof AbstractImmutableList && coll.getClass() != SubList.class) {
            return (List)coll;
        }
        return List.of(coll.toArray());
    }

    static <E extends PublicId> PublicIdList<E> emptyList() {
        return ListN.EMPTY_LIST;
    }

    public static <E extends PublicId> Set<E> emptySet() {
        return SetN.EMPTY_SET;
    }

    static {
        long nt = System.nanoTime();
        SALT = (int)(nt >>> 32 ^ nt);
    }

    static abstract class AbstractImmutableList<E extends PublicId>
    extends AbstractImmutableCollection<E>
    implements PublicIdList<E>,
    List<E>,
    RandomAccess {
        AbstractImmutableList() {
        }

        @Override
        public void add(int index, E element) {
            throw PublicIdCollections.uoe();
        }

        @Override
        public boolean addAll(int index, Collection<? extends E> c) {
            throw PublicIdCollections.uoe();
        }

        @Override
        public E remove(int index) {
            throw PublicIdCollections.uoe();
        }

        @Override
        public void replaceAll(UnaryOperator<E> operator) {
            throw PublicIdCollections.uoe();
        }

        @Override
        public E set(int index, E element) {
            throw PublicIdCollections.uoe();
        }

        @Override
        public void sort(Comparator<? super E> c) {
            throw PublicIdCollections.uoe();
        }

        @Override
        public AbstractImmutableList<E> subList(int fromIndex, int toIndex) {
            int size = this.size();
            AbstractImmutableList.subListRangeCheck(fromIndex, toIndex, size);
            return SubList.fromList(this, fromIndex, toIndex);
        }

        static void subListRangeCheck(int fromIndex, int toIndex, int size) {
            if (fromIndex < 0) {
                throw new IndexOutOfBoundsException("fromIndex = " + fromIndex);
            }
            if (toIndex > size) {
                throw new IndexOutOfBoundsException("toIndex = " + toIndex);
            }
            if (fromIndex > toIndex) {
                throw new IllegalArgumentException("fromIndex(" + fromIndex + ") > toIndex(" + toIndex + ")");
            }
        }

        @Override
        public Iterator<E> iterator() {
            return new ListItr(this, this.size());
        }

        @Override
        public ListIterator<E> listIterator() {
            return this.listIterator(0);
        }

        @Override
        public ListIterator<E> listIterator(int index) {
            int size = this.size();
            if (index < 0 || index > size) {
                throw this.outOfBounds(index);
            }
            return new ListItr(this, size, index);
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof List)) {
                return false;
            }
            Iterator oit = ((List)o).iterator();
            int s = this.size();
            for (int i = 0; i < s; ++i) {
                if (oit.hasNext() && ((PublicId)this.get(i)).equals(oit.next())) continue;
                return false;
            }
            return !oit.hasNext();
        }

        @Override
        public int indexOf(Object o) {
            Objects.requireNonNull(o);
            int s = this.size();
            for (int i = 0; i < s; ++i) {
                if (!o.equals(this.get(i))) continue;
                return i;
            }
            return -1;
        }

        @Override
        public int lastIndexOf(Object o) {
            Objects.requireNonNull(o);
            for (int i = this.size() - 1; i >= 0; --i) {
                if (!o.equals(this.get(i))) continue;
                return i;
            }
            return -1;
        }

        @Override
        public int hashCode() {
            int hash = 1;
            int s = this.size();
            for (int i = 0; i < s; ++i) {
                hash = 31 * hash + ((PublicId)this.get(i)).hashCode();
            }
            return hash;
        }

        @Override
        public boolean contains(Object o) {
            return this.indexOf(o) >= 0;
        }

        IndexOutOfBoundsException outOfBounds(int index) {
            return new IndexOutOfBoundsException("Index: " + index + " Size: " + this.size());
        }
    }

    static final class SubList<E extends PublicId>
    extends AbstractImmutableList<E>
    implements RandomAccess {
        private final List<E> root;
        private final int offset;
        private final int size;

        private SubList(List<E> root, int offset, int size) {
            this.root = root;
            this.offset = offset;
            this.size = size;
        }

        static <E extends PublicId> SubList<E> fromSubList(SubList<E> parent, int fromIndex, int toIndex) {
            return new SubList<E>(parent.root, parent.offset + fromIndex, toIndex - fromIndex);
        }

        static <E extends PublicId> SubList<E> fromList(List<E> list, int fromIndex, int toIndex) {
            return new SubList<E>(list, fromIndex, toIndex - fromIndex);
        }

        @Override
        public E get(int index) {
            Objects.checkIndex(index, this.size);
            return (E)((PublicId)this.root.get(this.offset + index));
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public Iterator<E> iterator() {
            return new ListItr(this, this.size());
        }

        @Override
        public ListIterator<E> listIterator(int index) {
            this.rangeCheck(index);
            return new ListItr(this, this.size(), index);
        }

        private void rangeCheck(int index) {
            if (index < 0 || index > this.size) {
                throw this.outOfBounds(index);
            }
        }

        @Override
        public void forEach(Consumer<? super E> consumer) {
            this.iterator().forEachRemaining(consumer);
        }

        @Override
        public PublicId[] toIdArray() {
            return new PublicId[0];
        }

        @Override
        public boolean contains(PublicId value) {
            Iterator<E> itr = this.iterator();
            while (itr.hasNext()) {
                if (!value.equals(itr.next())) continue;
                return true;
            }
            return false;
        }
    }

    public static final class ListN<E extends PublicId>
    extends AbstractImmutableList<E> {
        public static final PublicIdList EMPTY_LIST = new ListN(new PublicId[0]);
        private final List<E> elements;

        @SafeVarargs
        public ListN(E ... input) {
            this.elements = new ArrayList(input.length);
            this.elements.addAll(Arrays.asList(input));
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }

        @Override
        public int size() {
            return this.elements.size();
        }

        @Override
        public E get(int index) {
            return (E)((PublicId)this.elements.get(index));
        }

        @Override
        public void forEach(Consumer<? super E> consumer) {
            for (PublicId element : this.elements) {
                if (element == null) continue;
                consumer.accept(element);
            }
        }

        @Override
        public PublicId[] toIdArray() {
            return this.elements.toArray(new PublicId[0]);
        }

        @Override
        public boolean contains(PublicId value) {
            for (PublicId element : this.elements) {
                if (!value.equals(element)) continue;
                return true;
            }
            return false;
        }
    }

    public static final class SetN<E extends PublicId>
    extends AbstractImmutableSet<E> {
        public static final Set<?> EMPTY_SET = new SetN(new PublicId[0]);
        final PublicId[] elements;
        final int size;

        @SafeVarargs
        public SetN(E ... input) {
            this.size = input.length;
            this.elements = new PublicId[2 * input.length];
            for (int i = 0; i < input.length; ++i) {
                E e = input[i];
                int idx = this.probe(e);
                if (idx >= 0) {
                    throw new IllegalArgumentException("duplicate element: " + String.valueOf(e));
                }
                this.elements[-(idx + 1)] = e;
            }
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public boolean contains(Object o) {
            Objects.requireNonNull(o);
            return this.size > 0 && this.probe(o) >= 0;
        }

        @Override
        public Iterator<E> iterator() {
            return new SetNIterator();
        }

        @Override
        public int hashCode() {
            int h = 0;
            for (PublicId e : this.elements) {
                if (e == null) continue;
                h += e.hashCode();
            }
            return h;
        }

        private int probe(Object pe) {
            int idx = Math.floorMod(pe.hashCode(), this.elements.length);
            PublicId ee;
            while ((ee = this.elements[idx]) != null) {
                if (pe.equals(ee)) {
                    return idx;
                }
                if (++idx != this.elements.length) continue;
                idx = 0;
            }
            return -idx - 1;
        }

        @Override
        public void forEach(Consumer<? super E> consumer) {
            for (PublicId element : this.elements) {
                if (element == null) continue;
                consumer.accept(element);
            }
        }

        @Override
        public PublicId[] toIdArray() {
            return this.elements;
        }

        @Override
        public boolean contains(PublicId value) {
            for (PublicId element : this.elements) {
                if (!value.equals(element)) continue;
                return true;
            }
            return false;
        }

        private final class SetNIterator
        implements Iterator<E> {
            private int remaining;
            private int idx;

            SetNIterator() {
                this.remaining = SetN.this.size();
                if (this.remaining > 0) {
                    this.idx = Math.floorMod(SALT, SetN.this.elements.length);
                }
            }

            @Override
            public boolean hasNext() {
                return this.remaining > 0;
            }

            private int nextIndex() {
                int idx = this.idx;
                if (SALT >= 0) {
                    if (++idx >= SetN.this.elements.length) {
                        idx = 0;
                    }
                } else if (--idx < 0) {
                    idx = SetN.this.elements.length - 1;
                }
                this.idx = idx;
                return this.idx;
            }

            @Override
            public E next() {
                if (this.hasNext()) {
                    PublicId element;
                    while ((element = SetN.this.elements[this.nextIndex()]) == null) {
                    }
                    --this.remaining;
                    return element;
                }
                throw new NoSuchElementException();
            }
        }
    }

    public static final class Set12<E extends PublicId>
    extends AbstractImmutableSet<E> {
        final E e0;
        final E e1;

        public Set12(E e0) {
            this.e0 = (PublicId)Objects.requireNonNull(e0);
            this.e1 = null;
        }

        public Set12(E e0, E e1) {
            if (e0.equals(Objects.requireNonNull(e1))) {
                throw new IllegalArgumentException("duplicate element: " + String.valueOf(e0));
            }
            this.e0 = e0;
            this.e1 = e1;
        }

        @Override
        public int size() {
            return this.e1 == null ? 1 : 2;
        }

        @Override
        public boolean contains(Object o) {
            return o.equals(this.e0) || o.equals(this.e1);
        }

        @Override
        public int hashCode() {
            return this.e0.hashCode() + (this.e1 == null ? 0 : this.e1.hashCode());
        }

        @Override
        public Iterator<E> iterator() {
            return new Iterator<E>(){
                private int idx;
                {
                    this.idx = this.size();
                }

                @Override
                public boolean hasNext() {
                    return this.idx > 0;
                }

                @Override
                public E next() {
                    if (this.idx == 1) {
                        this.idx = 0;
                        return SALT >= 0 || e1 == null ? e0 : e1;
                    }
                    if (this.idx == 2) {
                        this.idx = 1;
                        return SALT >= 0 ? e1 : e0;
                    }
                    throw new NoSuchElementException();
                }
            };
        }

        @Override
        public void forEach(Consumer<? super E> consumer) {
            if (this.e0 != null) {
                consumer.accept(this.e0);
            }
            if (this.e1 != null) {
                consumer.accept(this.e1);
            }
        }

        @Override
        public PublicId[] toIdArray() {
            if (this.e0 != null) {
                if (this.e1 != null) {
                    return new PublicId[]{this.e0, this.e1};
                }
                return new PublicId[]{this.e0};
            }
            return new PublicId[0];
        }

        @Override
        public boolean contains(PublicId value) {
            if (this.e0 != null && value.equals(this.e0)) {
                return true;
            }
            if (this.e1 != null) {
                return value.equals(this.e1);
            }
            return false;
        }
    }

    static abstract class AbstractImmutableSet<E extends PublicId>
    extends AbstractImmutableCollection<E>
    implements Set<E>,
    PublicIdSet<E> {
        AbstractImmutableSet() {
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Set)) {
                return false;
            }
            Collection c = (Collection)o;
            if (c.size() != this.size()) {
                return false;
            }
            for (Object e : c) {
                if (e != null && this.contains(e)) continue;
                return false;
            }
            return true;
        }

        @Override
        public abstract int hashCode();
    }

    public static final class List12<E extends PublicId>
    extends AbstractImmutableList<E> {
        private final E e0;
        private final E e1;

        public List12(E e0) {
            this.e0 = (PublicId)Objects.requireNonNull(e0);
            this.e1 = null;
        }

        public List12(E e0, E e1) {
            this.e0 = (PublicId)Objects.requireNonNull(e0);
            this.e1 = (PublicId)Objects.requireNonNull(e1);
        }

        @Override
        public int size() {
            return this.e1 != null ? 2 : 1;
        }

        @Override
        public E get(int index) {
            if (index == 0) {
                return this.e0;
            }
            if (index == 1 && this.e1 != null) {
                return this.e1;
            }
            throw this.outOfBounds(index);
        }

        @Override
        public void forEach(Consumer<? super E> consumer) {
            if (this.e0 != null) {
                consumer.accept(this.e0);
            }
            if (this.e1 != null) {
                consumer.accept(this.e1);
            }
        }

        @Override
        public PublicId[] toIdArray() {
            if (this.e0 != null) {
                if (this.e1 != null) {
                    return new PublicId[]{this.e0, this.e1};
                }
                return new PublicId[]{this.e0};
            }
            return new PublicId[0];
        }

        @Override
        public boolean contains(PublicId value) {
            if (this.e0 != null && value.equals(this.e0)) {
                return true;
            }
            if (this.e1 != null) {
                return value.equals(this.e1);
            }
            return false;
        }
    }

    static final class ListItr<E>
    implements ListIterator<E> {
        private final List<E> list;
        private final int size;
        private final boolean isListIterator;
        private int cursor;

        ListItr(List<E> list, int size) {
            this.list = list;
            this.size = size;
            this.cursor = 0;
            this.isListIterator = false;
        }

        ListItr(List<E> list, int size, int index) {
            this.list = list;
            this.size = size;
            this.cursor = index;
            this.isListIterator = true;
        }

        @Override
        public boolean hasNext() {
            return this.cursor != this.size;
        }

        @Override
        public E next() {
            try {
                int i = this.cursor;
                E next = this.list.get(i);
                this.cursor = i + 1;
                return next;
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public void remove() {
            throw PublicIdCollections.uoe();
        }

        @Override
        public boolean hasPrevious() {
            if (!this.isListIterator) {
                throw PublicIdCollections.uoe();
            }
            return this.cursor != 0;
        }

        @Override
        public E previous() {
            if (!this.isListIterator) {
                throw PublicIdCollections.uoe();
            }
            try {
                int i = this.cursor - 1;
                E previous = this.list.get(i);
                this.cursor = i;
                return previous;
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public int nextIndex() {
            if (!this.isListIterator) {
                throw PublicIdCollections.uoe();
            }
            return this.cursor;
        }

        @Override
        public int previousIndex() {
            if (!this.isListIterator) {
                throw PublicIdCollections.uoe();
            }
            return this.cursor - 1;
        }

        @Override
        public void set(E e) {
            throw PublicIdCollections.uoe();
        }

        @Override
        public void add(E e) {
            throw PublicIdCollections.uoe();
        }
    }

    static abstract class AbstractImmutableCollection<E extends PublicId>
    extends AbstractCollection<E>
    implements PublicIdCollection<E> {
        AbstractImmutableCollection() {
        }

        @Override
        public boolean add(E e) {
            throw PublicIdCollections.uoe();
        }

        @Override
        public boolean addAll(Collection<? extends E> c) {
            throw PublicIdCollections.uoe();
        }

        @Override
        public void clear() {
            throw PublicIdCollections.uoe();
        }

        @Override
        public boolean remove(Object o) {
            throw PublicIdCollections.uoe();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw PublicIdCollections.uoe();
        }

        @Override
        public boolean removeIf(Predicate<? super E> filter) {
            throw PublicIdCollections.uoe();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw PublicIdCollections.uoe();
        }

        @Override
        public Stream<E> stream() {
            return StreamSupport.stream(this.spliterator(), false);
        }
    }
}

