/*
 * Decompiled with CFR 0.152.
 */
package dev.ikm.tinkar.common.id.impl;

import dev.ikm.tinkar.common.id.PublicId;
import dev.ikm.tinkar.common.util.uuid.UuidUtil;
import java.util.Arrays;
import java.util.UUID;
import java.util.function.LongConsumer;

public class PublicIdN
implements PublicId {
    private final long[] uuidParts;

    public PublicIdN(UUID ... uuids) {
        this.uuidParts = UuidUtil.asArray(uuids);
    }

    public PublicIdN(long ... uuidParts) {
        this.uuidParts = uuidParts;
    }

    @Override
    public int uuidCount() {
        return this.uuidParts.length / 2;
    }

    @Override
    public UUID[] asUuidArray() {
        return UuidUtil.toArray(this.uuidParts);
    }

    @Override
    public void forEach(LongConsumer consumer) {
        for (long uuidPart : this.uuidParts) {
            consumer.accept(uuidPart);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof PublicId) {
            PublicId publicId = (PublicId)o;
            UUID[] thisUuids = this.asUuidArray();
            return Arrays.stream(publicId.asUuidArray()).anyMatch(uuid -> {
                for (UUID thisUuid : thisUuids) {
                    if (!uuid.equals(thisUuid)) continue;
                    return true;
                }
                return false;
            });
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.uuidParts);
    }
}

