/*
 * Decompiled with CFR 0.152.
 */
package dev.ikm.tinkar.common.service;

import dev.ikm.tinkar.common.service.DataServiceProperty;
import dev.ikm.tinkar.common.service.DataUriOption;
import dev.ikm.tinkar.common.validation.ValidationRecord;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.eclipse.collections.api.factory.Maps;
import org.eclipse.collections.api.map.ImmutableMap;

public interface DataServiceController<T> {
    default public ImmutableMap<DataServiceProperty, String> providerProperties() {
        return Maps.immutable.empty();
    }

    default public Optional<String> getDataServiceProperty(DataServiceProperty propertyKey) {
        return Optional.ofNullable((String)this.providerProperties().get((Object)propertyKey));
    }

    default public void setDataServiceProperty(DataServiceProperty key, String value) {
        throw new UnsupportedOperationException();
    }

    default public ValidationRecord[] validate(DataServiceProperty dataServiceProperty, Object value, Object target) {
        return new ValidationRecord[0];
    }

    default public List<DataUriOption> providerOptions() {
        ArrayList<DataUriOption> dataUriOptions = new ArrayList<DataUriOption>();
        File rootFolder = new File(System.getProperty("user.home"), "Solor");
        if (!rootFolder.exists()) {
            rootFolder.mkdirs();
        }
        for (File f : rootFolder.listFiles()) {
            String[] children;
            if (!f.isDirectory() || (children = f.list((dir, name) -> this.isValidDataLocation(name))).length == 0) continue;
            dataUriOptions.add(new DataUriOption(f.getName(), f.toURI()));
        }
        return dataUriOptions;
    }

    public boolean isValidDataLocation(String var1);

    public void setDataUriOption(DataUriOption var1);

    public String controllerName();

    public Class<? extends T> serviceClass();

    public boolean running();

    public void start();

    public void stop();

    public void save();

    public void reload();

    public T provider();

    default public boolean loading() {
        return false;
    }
}

