/*
 * Decompiled with CFR 0.152.
 */
package dev.ikm.tinkar.common.service;

import dev.ikm.tinkar.common.alert.AlertStreams;
import dev.ikm.tinkar.common.id.IntIdCollection;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.eclipse.collections.api.list.primitive.IntList;
import org.eclipse.collections.api.set.primitive.IntSet;

public interface DefaultDescriptionForNidService {
    default public List<Optional<String>> optionalTextList(IntIdCollection nids) {
        return this.optionalTextList(nids.toArray());
    }

    default public List<Optional<String>> optionalTextList(int ... nids) {
        ArrayList<Optional<String>> textList = new ArrayList<Optional<String>>(nids.length);
        for (int nid : nids) {
            textList.add(this.textOptional(nid));
        }
        return textList;
    }

    default public Optional<String> textOptional(int nid) {
        try {
            return Optional.ofNullable(this.textFast(nid));
        }
        catch (RuntimeException ex) {
            AlertStreams.dispatchToRoot(ex);
            return Optional.empty();
        }
    }

    public String textFast(int var1);

    default public List<Optional<String>> optionalTextList(IntList nids) {
        return this.optionalTextList(nids.toArray());
    }

    default public List<Optional<String>> optionalTextList(IntSet nids) {
        return this.optionalTextList(nids.toArray());
    }

    default public List<String> textList(int ... nids) {
        ArrayList<String> textList = new ArrayList<String>(nids.length);
        for (int nid : nids) {
            textList.add(this.text(nid));
        }
        return textList;
    }

    default public String text(int nid) {
        Object textFast = this.textFast(nid);
        if (textFast == null) {
            textFast = "<" + nid + ">";
        }
        return textFast;
    }

    default public List<Optional<String>> textList(IntIdCollection nids) {
        return this.optionalTextList(nids.toArray());
    }

    default public List<Optional<String>> textList(IntList nids) {
        return this.optionalTextList(nids.toArray());
    }

    default public List<Optional<String>> textList(IntSet nids) {
        return this.optionalTextList(nids.toArray());
    }
}

