/*
 * Decompiled with CFR 0.152.
 */
package dev.ikm.tinkar.common.service;

import com.google.auto.service.AutoService;
import dev.ikm.tinkar.common.alert.AlertObject;
import dev.ikm.tinkar.common.alert.AlertStreams;
import dev.ikm.tinkar.common.id.IntIdCollection;
import dev.ikm.tinkar.common.id.PublicId;
import dev.ikm.tinkar.common.service.CachingService;
import dev.ikm.tinkar.common.service.DataServiceController;
import dev.ikm.tinkar.common.service.DefaultDescriptionForNidService;
import dev.ikm.tinkar.common.service.PrimitiveDataService;
import dev.ikm.tinkar.common.service.PublicIdService;
import dev.ikm.tinkar.common.service.SaveState;
import dev.ikm.tinkar.common.service.SimpleIndeterminateTracker;
import dev.ikm.tinkar.common.service.TinkExecutor;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.ToIntFunction;
import org.eclipse.collections.api.list.primitive.IntList;
import org.eclipse.collections.api.set.primitive.IntSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrimitiveData {
    private static final Logger LOG = LoggerFactory.getLogger(PrimitiveData.class);
    public static long PREMUNDANE_TIME = -9223372036854775807L;
    public static Instant PREMUNDANE_INSTANT = Instant.ofEpochSecond(Instant.MIN.getEpochSecond() + 1L, 0L);
    public static UUID NONEXISTENT_STAMP_UUID = UUID.fromString("00fea511-30eb-4bbb-9105-c846db5bf0ad");
    private static DataServiceController<PrimitiveDataService> controllerSingleton;
    private static DefaultDescriptionForNidService defaultDescriptionForNidServiceSingleton;
    private static PublicIdService publicIdServiceSingleton;
    private static PrimitiveData singleton;
    private static CopyOnWriteArrayList<SaveState> statesToSave;

    private PrimitiveData() {
    }

    public static void start() {
        controllerSingleton.start();
        ServiceLoader<DefaultDescriptionForNidService> loader = ServiceLoader.load(DefaultDescriptionForNidService.class);
        defaultDescriptionForNidServiceSingleton = loader.findFirst().get();
        ServiceLoader<PublicIdService> publicIdLoader = ServiceLoader.load(PublicIdService.class);
        publicIdServiceSingleton = publicIdLoader.findFirst().get();
        LOG.info("Default desc service: " + String.valueOf(defaultDescriptionForNidServiceSingleton));
    }

    public static void stop() {
        SimpleIndeterminateTracker progressTask = new SimpleIndeterminateTracker("Stop primitive data provider");
        TinkExecutor.threadPool().submit(progressTask);
        try {
            PrimitiveData.save();
            if (controllerSingleton != null) {
                controllerSingleton.stop();
            }
        }
        catch (Throwable ex) {
            LOG.error(ex.getLocalizedMessage(), ex);
        }
        finally {
            progressTask.finished();
        }
    }

    public static void save() {
        if (controllerSingleton != null) {
            controllerSingleton.save();
        }
        for (SaveState state : statesToSave) {
            try {
                state.save();
            }
            catch (Exception e) {
                AlertStreams.getRoot().dispatch(AlertObject.makeError(e));
            }
        }
    }

    public static CopyOnWriteArrayList<SaveState> getStatesToSave() {
        return statesToSave;
    }

    public static void reload() {
        controllerSingleton.reload();
    }

    public static boolean running() {
        if (controllerSingleton == null) {
            return false;
        }
        return controllerSingleton.running();
    }

    public static List<DataServiceController> getControllerOptions() {
        List<DataServiceController> dataServiceControllers = ServiceLoader.load(DataServiceController.class).stream().map(dataServiceControllerProvider -> (DataServiceController)dataServiceControllerProvider.get()).toList();
        return dataServiceControllers;
    }

    public static void selectControllerByName(String name) {
        PrimitiveData.selectController(dataServiceController -> {
            if (name.equals(dataServiceController.controllerName())) {
                return 1;
            }
            return -1;
        });
    }

    public static void selectController(ToIntFunction<DataServiceController<?>> scorer) {
        DataServiceController topContender = null;
        int topScore = -1;
        int controllerCount = 0;
        ServiceLoader<DataServiceController> loader = ServiceLoader.load(DataServiceController.class);
        for (DataServiceController controller : loader) {
            if (!PrimitiveDataService.class.isAssignableFrom(controller.serviceClass())) continue;
            ++controllerCount;
            int score = scorer.applyAsInt(controller);
            if (score <= topScore) continue;
            topScore = score;
            topContender = controller;
        }
        if (topScore <= -1) {
            throw new IllegalStateException("No DataServiceController selected for provider. Tried " + controllerCount);
        }
        PrimitiveData.setController(topContender);
    }

    public static DataServiceController getController() {
        return controllerSingleton;
    }

    public static void setController(DataServiceController controller) {
        controllerSingleton = controller;
    }

    public static String textFast(int nid) {
        return defaultDescriptionForNidServiceSingleton.textFast(nid);
    }

    public static String text(int nid) {
        Optional<String> textOptional = PrimitiveData.textOptional(nid);
        if (textOptional.isPresent()) {
            return textOptional.get();
        }
        return "<" + nid + ">";
    }

    public static Optional<String> textOptional(int nid) {
        try {
            return defaultDescriptionForNidServiceSingleton.textOptional(nid);
        }
        catch (RuntimeException ex) {
            AlertStreams.dispatchToRoot(ex);
            return Optional.empty();
        }
    }

    public static String textWithNid(int nid) {
        StringBuilder sb = new StringBuilder();
        PrimitiveData.textOptional(nid).ifPresent(s -> sb.append((String)s).append(" "));
        sb.append("<").append(nid).append(">");
        return sb.toString();
    }

    public static List<Optional<String>> optionalTextList(int ... nids) {
        return defaultDescriptionForNidServiceSingleton.optionalTextList(nids);
    }

    public static List<Optional<String>> optionalTextList(IntIdCollection nids) {
        return defaultDescriptionForNidServiceSingleton.optionalTextList(nids);
    }

    public static List<Optional<String>> optionalTextList(IntList nids) {
        return defaultDescriptionForNidServiceSingleton.optionalTextList(nids);
    }

    public static List<Optional<String>> optionalTextList(IntSet nids) {
        return defaultDescriptionForNidServiceSingleton.optionalTextList(nids);
    }

    public static List<String> textList(int ... nids) {
        return defaultDescriptionForNidServiceSingleton.textList(nids);
    }

    public static List<Optional<String>> textList(IntIdCollection nids) {
        return defaultDescriptionForNidServiceSingleton.textList(nids);
    }

    public static List<Optional<String>> textList(IntList nids) {
        return defaultDescriptionForNidServiceSingleton.textList(nids);
    }

    public static List<Optional<String>> textList(IntSet nids) {
        return defaultDescriptionForNidServiceSingleton.textList(nids);
    }

    public static PublicId publicId(int nid) {
        return publicIdServiceSingleton.publicId(nid);
    }

    public static int nid(PublicId publicId) {
        return PrimitiveData.get().nidForPublicId(publicId);
    }

    public static PrimitiveDataService get() {
        if (controllerSingleton != null) {
            return controllerSingleton.provider();
        }
        throw new IllegalStateException("No provider. Call Select provider prior to get()");
    }

    public static int nid(UUID ... uuids) {
        return PrimitiveData.get().nidForUuids(uuids);
    }

    static {
        statesToSave = new CopyOnWriteArrayList();
        try {
            singleton = new PrimitiveData();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    @AutoService(value={CachingService.class})
    public static class CacheProvider
    implements CachingService {
        @Override
        public void reset() {
            controllerSingleton = null;
            defaultDescriptionForNidServiceSingleton = null;
            publicIdServiceSingleton = null;
            statesToSave.clear();
            singleton = new PrimitiveData();
        }
    }
}

