/*
 * Decompiled with CFR 0.152.
 */
package dev.ikm.tinkar.common.service;

import com.google.auto.service.AutoService;
import dev.ikm.tinkar.common.id.PublicId;
import dev.ikm.tinkar.common.service.CachingService;
import dev.ikm.tinkar.common.service.NidGenerator;
import dev.ikm.tinkar.common.service.PrimitiveData;
import dev.ikm.tinkar.common.service.PrimitiveDataSearchResult;
import dev.ikm.tinkar.common.sets.ConcurrentHashSet;
import io.activej.bytebuf.ByteBuf;
import io.activej.bytebuf.ByteBufPool;
import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import java.util.function.ObjIntConsumer;
import org.eclipse.collections.api.block.procedure.primitive.ByteProcedure;
import org.eclipse.collections.api.block.procedure.primitive.IntProcedure;
import org.eclipse.collections.api.factory.Lists;
import org.eclipse.collections.api.factory.Sets;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.api.list.ListIterable;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.list.primitive.ByteList;
import org.eclipse.collections.api.list.primitive.ImmutableIntList;
import org.eclipse.collections.api.list.primitive.MutableIntList;
import org.eclipse.collections.api.set.MutableSet;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.factory.primitive.ByteLists;
import org.eclipse.collections.impl.factory.primitive.IntLists;
import org.eclipse.collections.impl.factory.primitive.LongSets;

public interface PrimitiveDataService {
    public static final int FIRST_NID = -2147483647;
    public static final byte STAMP_DATA_TYPE = 7;
    public static final ConcurrentHashSet<Integer> canceledStampNids = new ConcurrentHashSet();

    public static int nidForUuids(ConcurrentMap<UUID, Integer> uuidNidMap, NidGenerator nidGenerator, ImmutableList<UUID> uuidList) {
        switch (uuidList.size()) {
            case 0: {
                throw new IllegalStateException("uuidList cannot be empty");
            }
            case 1: {
                return PrimitiveDataService.valueOrGenerateAndPut((UUID)uuidList.get(0), uuidNidMap, nidGenerator);
            }
        }
        return PrimitiveDataService.valueOrGenerateForList((ListIterable<UUID>)uuidList.toSortedList(), uuidNidMap, nidGenerator);
    }

    public static int valueOrGenerateAndPut(UUID uuid, ConcurrentMap<UUID, Integer> uuidNidMap, NidGenerator nidGenerator) {
        Integer nid = (Integer)uuidNidMap.get(uuid);
        if (nid != null) {
            return nid;
        }
        nid = uuidNidMap.computeIfAbsent(uuid, uuidKey -> nidGenerator.newNid());
        return nid;
    }

    public static int valueOrGenerateForList(ListIterable<UUID> sortedUuidList, ConcurrentMap<UUID, Integer> uuidNidMap, NidGenerator nidGenerator) {
        boolean missingMap = false;
        int foundValue = Integer.MIN_VALUE;
        for (UUID uuid : sortedUuidList) {
            Integer nid = (Integer)uuidNidMap.get(uuid);
            if (nid == null) {
                missingMap = true;
                continue;
            }
            if (foundValue == Integer.MIN_VALUE) {
                foundValue = nid;
                continue;
            }
            if (foundValue == nid) continue;
            StringBuilder sb = new StringBuilder();
            sb.append("Multiple nids for: ");
            sb.append(sortedUuidList);
            sb.append(" first value: ").append(foundValue);
            sb.append(" second value: ").append(nid);
            throw new IllegalStateException(sb.toString());
        }
        if (!missingMap) {
            return foundValue;
        }
        if (foundValue == Integer.MIN_VALUE) {
            foundValue = PrimitiveDataService.valueOrGenerateAndPut((UUID)sortedUuidList.get(0), uuidNidMap, nidGenerator);
        }
        for (UUID uuid : sortedUuidList) {
            uuidNidMap.put(uuid, foundValue);
        }
        return foundValue;
    }

    public static int nidForUuids(ConcurrentMap<UUID, Integer> uuidNidMap, NidGenerator nidGenerator, UUID ... uuids) {
        switch (uuids.length) {
            case 0: {
                throw new IllegalStateException("uuidList cannot be empty");
            }
            case 1: {
                return PrimitiveDataService.valueOrGenerateAndPut(uuids[0], uuidNidMap, nidGenerator);
            }
        }
        Arrays.sort(uuids);
        return PrimitiveDataService.valueOrGenerateForList((ListIterable<UUID>)Lists.immutable.of((Object[])uuids), uuidNidMap, nidGenerator);
    }

    public static byte[] merge(byte[] oldBytes, byte[] newBytes) {
        if (oldBytes == null) {
            return newBytes;
        }
        if (newBytes == null) {
            return oldBytes;
        }
        if (Arrays.equals(oldBytes, newBytes)) {
            return oldBytes;
        }
        try {
            MutableSet byteArraySet = Sets.mutable.empty();
            MutableIntList stampList = IntLists.mutable.withInitialCapacity(16);
            PrimitiveDataService.addToSet(newBytes, (MutableSet<ByteList>)byteArraySet, stampList);
            PrimitiveDataService.addToSet(oldBytes, (MutableSet<ByteList>)byteArraySet, stampList);
            MutableList byteArrayList = byteArraySet.toList();
            byteArrayList.sort((o1, o2) -> {
                int minSize = Math.min(o1.size(), o2.size());
                for (int i = 0; i < minSize; ++i) {
                    if (o1.get(i) == o2.get(i)) continue;
                    return Integer.compare(o1.get(i), o2.get(i));
                }
                return Integer.compare(o1.size(), o2.size());
            });
            if (byteArrayList.size() > 2) {
                MutableIntList indexesToRemove = IntLists.mutable.empty();
                block5: for (int i = 1; i < byteArrayList.size(); ++i) {
                    ByteList versionBytes = (ByteList)byteArrayList.get(i);
                    byte versionToken = versionBytes.get(0);
                    switch (versionToken) {
                        case 4: 
                        case 5: 
                        case 6: {
                            int stampNid = (versionBytes.get(1) & 0xFF) << 24 | (versionBytes.get(2) & 0xFF) << 16 | (versionBytes.get(3) & 0xFF) << 8 | (versionBytes.get(4) & 0xFF) << 0;
                            if (!PrimitiveData.get().isCanceledStampNid(stampNid)) continue block5;
                            indexesToRemove.add(i);
                        }
                    }
                }
                indexesToRemove.reverseThis().forEach((IntProcedure & Serializable)index -> byteArrayList.remove(index));
            }
            ByteBuf byteBuf = ByteBufPool.allocate((int)(oldBytes.length + newBytes.length));
            byteBuf.writeInt(byteArrayList.size());
            boolean first = true;
            for (ByteList byteArray : byteArrayList) {
                if (first) {
                    byteBuf.writeInt(byteArray.size() + 4);
                    byteArray.forEach((ByteProcedure & Serializable)b -> byteBuf.put(b));
                    byteBuf.writeInt(byteArrayList.size() - 1);
                    first = false;
                    continue;
                }
                byteBuf.writeInt(byteArray.size());
                byteArray.forEach((ByteProcedure & Serializable)b -> byteBuf.put(b));
            }
            return byteBuf.asArray();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static void addToSet(byte[] bytes, MutableSet<ByteList> byteArraySet, MutableIntList stampsInSet) throws IOException {
        ByteBuf readBuf = ByteBuf.wrapForReading((byte[])bytes);
        boolean stampDataType = bytes[9] == 7;
        int arrayCount = readBuf.readInt();
        for (int i = 0; i < arrayCount; ++i) {
            byte[] newArray;
            int arraySize = readBuf.readInt();
            if (i == 0) {
                newArray = new byte[arraySize - 4];
                readBuf.read(newArray);
                byteArraySet.add((Object)ByteLists.immutable.of(newArray));
                int versionCount = readBuf.readInt();
                if (versionCount == arrayCount - 1) continue;
                throw new IllegalStateException("Malformed data. versionCount: " + versionCount + " arrayCount: " + arrayCount);
            }
            newArray = new byte[arraySize];
            readBuf.read(newArray);
            if (stampDataType) {
                byteArraySet.add((Object)ByteLists.immutable.of(newArray));
                continue;
            }
            int stampNid = (newArray[1] & 0xFF) << 24 | (newArray[2] & 0xFF) << 16 | (newArray[3] & 0xFF) << 8 | (newArray[4] & 0xFF) << 0;
            if (stampsInSet.contains(stampNid)) continue;
            byteArraySet.add((Object)ByteLists.immutable.of(newArray));
            stampsInSet.add(stampNid);
        }
    }

    default public boolean isCanceledStampNid(int stampNid) {
        return canceledStampNids.contains(stampNid);
    }

    public static long[] mergeCitations(long[] citation1, long[] citation2) {
        if (citation1 == null) {
            return citation2;
        }
        if (citation2 == null) {
            return citation1;
        }
        if (Arrays.equals(citation1, citation2)) {
            return citation1;
        }
        MutableLongSet citationSet = LongSets.mutable.of(citation1);
        citationSet.addAll(citation2);
        return citationSet.toSortedArray();
    }

    public long writeSequence();

    public void close();

    default public int nidForPublicId(PublicId publicId) {
        return this.nidForUuids(publicId.asUuidArray());
    }

    public int nidForUuids(UUID ... var1);

    public int nidForUuids(ImmutableList<UUID> var1);

    public void forEach(ObjIntConsumer<byte[]> var1);

    public void forEachParallel(ObjIntConsumer<byte[]> var1);

    public void forEachParallel(ImmutableIntList var1, ObjIntConsumer<byte[]> var2);

    public byte[] getBytes(int var1);

    public byte[] merge(int var1, int var2, int var3, byte[] var4, Object var5);

    public PrimitiveDataSearchResult[] search(String var1, int var2) throws Exception;

    default public int[] semanticNidsOfPattern(int patternNid) {
        MutableIntList intList = IntLists.mutable.empty();
        this.forEachSemanticNidOfPattern(patternNid, (IntProcedure & Serializable)nid -> intList.add(nid));
        return intList.toArray();
    }

    public void forEachSemanticNidOfPattern(int var1, IntProcedure var2);

    public void forEachPatternNid(IntProcedure var1);

    public void forEachConceptNid(IntProcedure var1);

    public void forEachStampNid(IntProcedure var1);

    public void forEachSemanticNid(IntProcedure var1);

    default public int[] semanticNidsForComponent(int componentNid) {
        MutableIntList intList = IntLists.mutable.empty();
        this.forEachSemanticNidForComponent(componentNid, (IntProcedure & Serializable)nid -> intList.add(nid));
        return intList.toArray();
    }

    public void forEachSemanticNidForComponent(int var1, IntProcedure var2);

    default public int[] semanticNidsForComponentOfPattern(int componentNid, int patternNid) {
        MutableIntList intList = IntLists.mutable.empty();
        this.forEachSemanticNidForComponentOfPattern(componentNid, patternNid, (IntProcedure & Serializable)nid -> intList.add(nid));
        return intList.toArray();
    }

    public void forEachSemanticNidForComponentOfPattern(int var1, int var2, IntProcedure var3);

    default public void addCanceledStampNid(int stampNid) {
        canceledStampNids.add(stampNid);
    }

    public String name();

    @AutoService(value={CachingService.class})
    public static class CacheProvider
    implements CachingService {
        @Override
        public void reset() {
            canceledStampNids.clear();
        }
    }

    public static enum RemoteOperations {
        NID_FOR_UUIDS(1),
        GET_BYTES(2),
        MERGE(3);

        public final byte token;

        private RemoteOperations(int token) {
            this.token = (byte)token;
        }

        public static RemoteOperations fromToken(byte token) {
            switch (token) {
                case 1: {
                    return NID_FOR_UUIDS;
                }
                case 2: {
                    return GET_BYTES;
                }
                case 3: {
                    return MERGE;
                }
            }
            throw new UnsupportedOperationException("Can't handle token: " + token);
        }
    }
}

