/*
 * Decompiled with CFR 0.152.
 */
package dev.ikm.tinkar.common.service;

import com.google.auto.service.AutoService;
import dev.ikm.tinkar.common.service.CachingService;
import dev.ikm.tinkar.common.service.ServiceKeys;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceProperties {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceProperties.class);
    private static final ConcurrentHashMap<Enum, Object> propertyMap = new ConcurrentHashMap();

    public static final <T> T get(Enum enumKey, T defaultValue) {
        if (propertyMap.containsKey(enumKey)) {
            return (T)propertyMap.get(enumKey);
        }
        return defaultValue;
    }

    public static final void set(Enum enumKey, Object value) {
        propertyMap.put(enumKey, value);
    }

    public static final String jvmUuid() {
        Optional jvmUuidOptional = ServiceProperties.get(ServiceKeys.JVM_UUID);
        StringBuilder infoString = new StringBuilder();
        if (jvmUuidOptional.isPresent()) {
            infoString.append("JVM UUID: " + String.valueOf(jvmUuidOptional.get()));
        } else {
            infoString.append("JVM UUID: Not initialized");
        }
        Optional cachePeriodUuidOptional = ServiceProperties.get(ServiceKeys.CACHE_PERIOD_UUID);
        if (cachePeriodUuidOptional.isPresent()) {
            infoString.append(" Cache period UUID: " + String.valueOf(cachePeriodUuidOptional.get()));
        } else {
            infoString.append(" Cache period UUID: Not initialized ");
        }
        return infoString.toString();
    }

    public static final <T> Optional<T> get(Enum enumKey) {
        return Optional.ofNullable(propertyMap.get(enumKey));
    }

    static {
        propertyMap.putIfAbsent(ServiceKeys.JVM_UUID, UUID.randomUUID());
        propertyMap.putIfAbsent(ServiceKeys.CACHE_PERIOD_UUID, UUID.randomUUID());
    }

    @AutoService(value={CachingService.class})
    public static class CacheProvider
    implements CachingService {
        @Override
        public void reset() {
            UUID currentUuid = (UUID)propertyMap.get((Object)ServiceKeys.JVM_UUID);
            LOG.info("Resetting ServiceProperties for: " + String.valueOf(currentUuid));
            propertyMap.clear();
            propertyMap.put(ServiceKeys.JVM_UUID, currentUuid);
            propertyMap.putIfAbsent(ServiceKeys.CACHE_PERIOD_UUID, UUID.randomUUID());
        }
    }
}

