/*
 * Decompiled with CFR 0.152.
 */
package dev.ikm.tinkar.common.service;

import dev.ikm.tinkar.common.service.TrackingCallable;

public class SimpleIndeterminateTracker
extends TrackingCallable<Void> {
    boolean finished = false;
    String title;
    private Thread sleepingThread;

    public SimpleIndeterminateTracker(String title) {
        super(false, true);
        this.title = title;
        this.updateTitle(title + " executing");
    }

    public void finished() {
        this.finished = true;
        if (this.sleepingThread != null) {
            this.sleepingThread.interrupt();
        }
    }

    @Override
    protected Void compute() throws Exception {
        while (!this.finished) {
            try {
                this.sleepingThread = Thread.currentThread();
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                if (!this.finished) continue;
                break;
            }
        }
        this.updateTitle(this.title + " completed");
        this.updateMessage("In " + this.durationString());
        return null;
    }
}

