/*
 * Decompiled with CFR 0.152.
 */
package dev.ikm.tinkar.common.service;

import dev.ikm.tinkar.common.service.TrackingListener;
import dev.ikm.tinkar.common.util.time.DurationUtil;
import dev.ikm.tinkar.common.util.time.Stopwatch;
import java.time.Duration;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.DoubleAdder;

public abstract class TrackingCallable<V>
implements Callable<V> {
    final boolean allowUserCancel;
    final boolean retainWhenComplete;
    Stopwatch stopwatch = new Stopwatch();
    TrackingListener listener;
    DoubleAdder workDone = new DoubleAdder();
    DoubleAdder maxWork = new DoubleAdder();
    double updateThreshold = 0.005;
    String title;
    String message;
    V value;
    boolean isCancelled = false;

    public TrackingCallable() {
        this.allowUserCancel = true;
        this.retainWhenComplete = false;
    }

    public TrackingCallable(boolean allowUserCancel, boolean retainWhenComplete) {
        this.allowUserCancel = allowUserCancel;
        this.retainWhenComplete = retainWhenComplete;
    }

    public TrackingCallable(boolean allowUserCancel) {
        this.allowUserCancel = allowUserCancel;
        this.retainWhenComplete = false;
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    public void cancel() {
        this.isCancelled = true;
    }

    public boolean allowUserCancel() {
        return this.allowUserCancel;
    }

    public boolean updateIntervalElapsed() {
        return this.stopwatch.updateIntervalElapsed();
    }

    public boolean retainWhenComplete() {
        return this.retainWhenComplete;
    }

    @Override
    public final V call() throws Exception {
        this.stopwatch.reset();
        try {
            V result = this.compute();
            this.stopwatch.stop();
            return result;
        }
        catch (Throwable th) {
            this.stopwatch.stop();
            if (th instanceof Exception) {
                Exception ex = (Exception)th;
                throw ex;
            }
            throw new Exception(th);
        }
    }

    protected abstract V compute() throws Exception;

    public void addListener(TrackingListener listener) {
        if (this.listener != null) {
            throw new IllegalStateException("Listener already set");
        }
        this.listener = listener;
        this.listener.updateValue(this.value);
        this.listener.updateMessage(this.message);
        this.listener.updateTitle(this.title);
        this.listener.updateProgress(this.workDone.sum(), this.maxWork.sum());
    }

    public String getTitle() {
        return this.title;
    }

    public String getMessage() {
        return this.message;
    }

    public String estimateTimeRemainingString() {
        return "About " + DurationUtil.format(this.estimateTimeRemaining()) + " remaining.";
    }

    public Duration estimateTimeRemaining() {
        if (this.maxWork.sum() == 0.0) {
            return Duration.ofDays(365L);
        }
        double percentDone = this.workDone.sum() / this.maxWork.sum();
        if (percentDone < 1.0E-5) {
            return Duration.ofDays(365L);
        }
        double secondsDuration = this.duration().getSeconds();
        double secondsRemaining = secondsDuration / this.workDone.sum() * (this.maxWork.sum() - this.workDone.sum());
        return Duration.ofSeconds((long)secondsRemaining);
    }

    public Duration duration() {
        return this.stopwatch.duration();
    }

    public void completedUnitOfWork() {
        this.workDone.add(1.0);
        if (this.listener != null && this.workDone.sum() % 128.0 == 0.0) {
            this.listener.updateProgress(this.workDone.sum(), this.maxWork.sum());
        }
    }

    public String durationString() {
        return this.stopwatch.durationString();
    }

    public Duration averageDurationForElement(int count) {
        return this.stopwatch.averageDurationForElement(count);
    }

    public String averageDurationForElementString(int count) {
        return this.stopwatch.averageDurationForElementString(count);
    }

    public void updateValue(V result) {
        if (this.listener != null) {
            this.listener.updateValue(result);
        }
    }

    public void updateMessage(String message) {
        if (message != null && this.message == null) {
            if (this.listener != null) {
                this.listener.updateMessage(message);
            }
        } else if (this.listener != null && !this.message.equals(message)) {
            this.listener.updateMessage(message);
        }
        this.message = message;
    }

    public void updateTitle(String title) {
        this.title = title;
        if (this.listener != null) {
            this.listener.updateTitle(title);
        }
    }

    public void addToTotalWork(long amountToAdd) {
        this.maxWork.add(amountToAdd);
        this.updateProgress(this.workDone.sum(), this.maxWork.sum());
    }

    public void updateProgress(double workDone, double maxWork) {
        boolean update = false;
        if (this.maxWork.sum() != maxWork) {
            this.maxWork.reset();
            this.maxWork.add(maxWork);
            this.workDone.reset();
            this.workDone.add(workDone);
            update = true;
        } else {
            double difference = workDone - this.workDone.sum();
            double percentDifference = difference / maxWork;
            if (percentDifference > this.updateThreshold) {
                update = true;
                this.workDone.reset();
                this.workDone.add(workDone);
            }
        }
        if (this.listener != null && update) {
            this.listener.updateProgress(workDone, maxWork);
        }
    }

    public void updateProgress(long workDone, long maxWork) {
        this.updateProgress((double)workDone, (double)maxWork);
    }
}

