/*
 * Decompiled with CFR 0.152.
 */
package dev.ikm.tinkar.common.sets;

import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class ConcurrentHashSet<T>
implements Set<T> {
    final ConcurrentHashMap.KeySetView<T, Boolean> keySet;

    public ConcurrentHashSet(int initialSize) {
        this.keySet = ConcurrentHashMap.newKeySet(initialSize);
    }

    public ConcurrentHashSet() {
        this.keySet = ConcurrentHashMap.newKeySet();
    }

    public ConcurrentHashSet(Enumeration<T> keys) {
        this.keySet = ConcurrentHashMap.newKeySet();
        while (keys.hasMoreElements()) {
            T value = keys.nextElement();
            this.keySet.add(value);
        }
    }

    @Override
    public int size() {
        return this.keySet.size();
    }

    @Override
    public boolean isEmpty() {
        return this.keySet.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.keySet.contains(o);
    }

    @Override
    public Iterator<T> iterator() {
        return this.keySet.iterator();
    }

    @Override
    public T[] toArray() {
        return this.keySet.toArray(new Object[this.keySet.size()]);
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.keySet.toArray(a);
    }

    @Override
    public boolean add(T value) {
        return this.keySet.add(value);
    }

    @Override
    public boolean remove(Object o) {
        return this.keySet.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.keySet.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        return this.keySet.addAll((Collection<T>)c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        this.keySet.clear();
    }
}

