/*
 * Decompiled with CFR 0.152.
 */
package dev.ikm.tinkar.common.util.broadcast;

import dev.ikm.tinkar.common.util.broadcast.Broadcaster;
import dev.ikm.tinkar.common.util.broadcast.Subscriber;
import java.lang.ref.WeakReference;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleBroadcaster<T>
implements Broadcaster<T>,
Subscriber<T> {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleBroadcaster.class);
    final CopyOnWriteArrayList<WeakReference<Subscriber<T>>> subscriberWeakReferenceList = new CopyOnWriteArrayList();

    @Override
    public void dispatch(T item) {
        for (WeakReference<Subscriber<T>> subscriberWeakReference : this.subscriberWeakReferenceList) {
            try {
                Subscriber subscriber = (Subscriber)subscriberWeakReference.get();
                if (subscriber == null) {
                    this.subscriberWeakReferenceList.remove(subscriberWeakReference);
                    continue;
                }
                subscriber.onNext(item);
            }
            catch (Throwable t) {
                LOG.error(t.getMessage(), t);
                this.subscriberWeakReferenceList.remove(subscriberWeakReference);
            }
        }
    }

    @Override
    public void onNext(T item) {
        this.dispatch(item);
    }

    @Override
    public void addSubscriberWithWeakReference(Subscriber<T> subscriber) {
        LOG.atDebug().log(String.valueOf(subscriber) + " subscribing to " + String.valueOf(this));
        for (WeakReference<Subscriber<T>> subscriberWeakReference : this.subscriberWeakReferenceList) {
            if (subscriberWeakReference.get() != subscriber) continue;
            throw new IllegalStateException("Trying to add duplicate listener: " + String.valueOf(subscriber));
        }
        this.subscriberWeakReferenceList.add(new WeakReference<Subscriber<T>>(subscriber));
    }

    @Override
    public void removeSubscriber(Subscriber<T> subscriber) {
        LOG.atDebug().log("Removing " + String.valueOf(subscriber) + " from " + String.valueOf(this));
        for (WeakReference<Subscriber<T>> subscriberWeakReference : this.subscriberWeakReferenceList) {
            if (subscriberWeakReference.get() != subscriber) continue;
            this.subscriberWeakReferenceList.remove(subscriberWeakReference);
        }
    }
}

