/*
 * Decompiled with CFR 0.152.
 */
package dev.ikm.tinkar.common.util.io;

import java.io.IOException;
import java.io.InputStream;

public class CountingInputStream
extends InputStream
implements AutoCloseable {
    private long bytesRead = 0L;
    private final InputStream stream;

    public CountingInputStream(InputStream stream) {
        this.stream = stream;
    }

    @Override
    public int read() throws IOException {
        int result = this.stream.read();
        if (result != -1) {
            ++this.bytesRead;
        }
        return result;
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.stream.close();
    }

    public long getBytesRead() {
        return this.bytesRead;
    }
}

