/*
 * Decompiled with CFR 0.152.
 */
package dev.ikm.tinkar.common.util.io;

import dev.ikm.tinkar.common.alert.AlertObject;
import dev.ikm.tinkar.common.alert.AlertStreams;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtil {
    private static final Logger LOG = LoggerFactory.getLogger(FileUtil.class);

    public static Optional<String> readFile(File file) {
        return FileUtil.readFile(file.toPath());
    }

    public static Optional<String> readFile(Path path) {
        try {
            return Optional.ofNullable(Files.readString(path));
        }
        catch (IOException e) {
            AlertStreams.getRoot().dispatch(AlertObject.makeError(e));
            return Optional.empty();
        }
    }

    public static void recursiveDelete(File file) {
        if (file == null || !file.exists()) {
            return;
        }
        try {
            Files.walk(file.toPath(), new FileVisitOption[0]).sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
        }
        catch (IOException e) {
            AlertStreams.getRoot().dispatch(AlertObject.makeError(e));
        }
    }

    public void writeFile(File file, String content) {
        this.writeFile(file.toPath(), content);
    }

    public void writeFile(Path path, String content) {
        try {
            Files.writeString(path, (CharSequence)content, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

