/*
 * Decompiled with CFR 0.152.
 */
package dev.ikm.tinkar.common.util.text;

import java.util.Comparator;

public class NaturalOrder<T>
implements Comparator<T> {
    private static final Comparator<Object> objectNaturalOrder = new NaturalOrder<Object>();
    private static final Comparator<String> stringNaturalOrder = new StringNaturalOrder();

    private NaturalOrder() {
    }

    public static final Comparator<Object> getObjectComparator() {
        return objectNaturalOrder;
    }

    public static final Comparator<String> getStringComparator() {
        return stringNaturalOrder;
    }

    public static final int compareStrings(String s1, String s2) {
        int len1 = s1.length();
        int len2 = s2.length();
        char c1 = '\u0000';
        char c2 = '\u0000';
        for (int i = 0; i < len1 && i < len2; ++i) {
            char c = s1.charAt(i);
            c1 = c;
            c2 = s2.charAt(i);
            if (c != c2 && Character.toLowerCase(s1.charAt(i)) != Character.toLowerCase(s2.charAt(i))) break;
        }
        if (c1 == '.' && c2 == ' ') {
            return -1;
        }
        if (c1 == ' ' && c2 == '.') {
            return 1;
        }
        if (Character.toLowerCase(c1) == Character.toLowerCase(c2)) {
            return len1 - len2;
        }
        if (Character.isDigit(c1)) {
            int x2;
            int x1;
            if (!Character.isDigit(c2)) {
                return 1;
            }
            for (x1 = i + 1; x1 < len1 && Character.isDigit(s1.charAt(x1)); ++x1) {
            }
            for (x2 = i + 1; x2 < len2 && Character.isDigit(s2.charAt(x2)); ++x2) {
            }
            return x2 == x1 ? c1 - c2 : x1 - x2;
        }
        if (Character.isDigit(c2)) {
            return -1;
        }
        return Character.toLowerCase(c1) - Character.toLowerCase(c2);
    }

    @Override
    public int compare(Object o1, Object o2) {
        return NaturalOrder.compareStrings(o1.toString(), o2.toString());
    }

    private static class StringNaturalOrder
    implements Comparator<String> {
        private StringNaturalOrder() {
        }

        @Override
        public int compare(String s1, String s2) {
            return NaturalOrder.compareStrings(s1, s2);
        }
    }
}

