/*
 * Decompiled with CFR 0.152.
 */
package dev.ikm.tinkar.common.util.thread;

import dev.ikm.tinkar.common.alert.AlertObject;
import dev.ikm.tinkar.common.alert.AlertStreams;
import java.util.concurrent.ThreadFactory;

public class NamedThreadFactory
implements ThreadFactory {
    private final int threadPriority;
    private final boolean daemon;
    private ThreadGroup threadGroup = null;
    private String threadNamePrefix = null;

    public NamedThreadFactory(boolean daemon) {
        this(null, null, 5, daemon);
    }

    public NamedThreadFactory(ThreadGroup threadGroup, String threadNamePrefix, int threadPriority, boolean daemon) {
        this.threadGroup = threadGroup;
        this.threadNamePrefix = threadNamePrefix;
        this.threadPriority = threadPriority;
        this.daemon = daemon;
        if (threadGroup != null && threadGroup.getMaxPriority() < threadPriority) {
            threadGroup.setMaxPriority(threadPriority);
        }
    }

    public NamedThreadFactory(String threadNamePrefix, boolean daemon) {
        this(null, threadNamePrefix, 5, daemon);
    }

    public NamedThreadFactory(ThreadGroup threadGroup, String threadNamePrefix) {
        this(threadGroup, threadNamePrefix, 5, true);
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread t = this.threadGroup == null ? new Thread(r) : new Thread(this.threadGroup, r);
        t.setName((String)(this.threadNamePrefix == null ? "" : this.threadNamePrefix + " ") + t.getId());
        t.setPriority(this.threadPriority);
        t.setDaemon(this.daemon);
        t.setUncaughtExceptionHandler((t1, e) -> AlertStreams.getRoot().dispatch(AlertObject.makeError(e)));
        return t;
    }
}

