/*
 * Decompiled with CFR 0.152.
 */
package dev.ikm.tinkar.common.util.thread;

import java.util.concurrent.Semaphore;

public class TaskCountManager {
    private final int taskCount;
    private final Semaphore taskSemaphore;

    public static TaskCountManager get() {
        return new TaskCountManager();
    }

    public TaskCountManager(int taskCount) {
        this.taskCount = taskCount;
        this.taskSemaphore = new Semaphore(taskCount);
    }

    public TaskCountManager() {
        this(Runtime.getRuntime().availableProcessors() * 2);
    }

    public void acquire() throws InterruptedException {
        this.taskSemaphore.acquire();
    }

    public void release() {
        this.taskSemaphore.release();
    }

    public void waitForCompletion() throws InterruptedException {
        this.taskSemaphore.acquire(this.taskCount);
        this.taskSemaphore.release(this.taskCount);
    }
}

