/*
 * Decompiled with CFR 0.152.
 */
package dev.ikm.tinkar.common.util.time;

import dev.ikm.tinkar.common.service.PrimitiveData;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;

public class DateTimeUtil {
    public static final long MS_IN_YEAR = 31536000000L;
    public static final long MS_IN_MONTH = 2592000000L;
    public static final long MS_IN_DAY = 86400000L;
    public static final long MS_IN_HOUR = 3600000L;
    public static final long MS_IN_MINUTE = 60000L;
    public static final long MS_IN_SEC = 1000L;
    public static final DateTimeFormatter EASY_TO_READ_DATE_FORMAT = DateTimeFormatter.ofPattern("MMM dd, yyyy");
    public static final DateTimeFormatter EASY_TO_READ_TIME_FORMAT = DateTimeFormatter.ofPattern("h:mm a zzz");
    public static final DateTimeFormatter EASY_TO_READ_DATE_TIME_FORMAT = DateTimeFormatter.ofPattern("h:mm a zzz MMM dd, yyyy");
    public static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm");
    public static final DateTimeFormatter SEC_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    public static final DateTimeFormatter MIN_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm");
    public static final DateTimeFormatter SHORT_MIN_FORMATTER = DateTimeFormatter.ofPattern("yy-MM-dd HH:mm");
    public static final DateTimeFormatter HOUR_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:00");
    public static final DateTimeFormatter DAY_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    public static final DateTimeFormatter MONTH_FORMATTER = DateTimeFormatter.ofPattern("MMMM yyyy");
    public static final DateTimeFormatter YEAR_FORMATTER = DateTimeFormatter.ofPattern("yyyy");
    public static final DateTimeFormatter ZONE_FORMATTER = DateTimeFormatter.ISO_DATE_TIME;
    public static final DateTimeFormatter TEXT_FORMAT_WITH_ZONE = DateTimeFormatter.ofPattern("MMM dd, yyyy; hh:mm:ss a zzz");
    public static final DateTimeFormatter TIME_SIMPLE = DateTimeFormatter.ofPattern("HH:mm:ss");
    public static final DateTimeFormatter COMPRESSED_DATE_TIME = DateTimeFormatter.ofPattern("yyyyMMdd'T'HHmmssz");
    public static final String LATEST = "Latest";
    public static final String CANCELED = "Canceled";
    public static final String PREMUNDANE = "Premundane";

    public static Instant epochMsToInstant(long epochMilliSecond) {
        if (epochMilliSecond == Long.MAX_VALUE) {
            return Instant.MAX;
        }
        if (epochMilliSecond == Long.MIN_VALUE) {
            return Instant.MIN;
        }
        return Instant.ofEpochMilli(epochMilliSecond);
    }

    public static long instantToEpochMs(Instant instant) {
        if (instant.equals(Instant.MIN)) {
            return Long.MIN_VALUE;
        }
        if (instant.equals(Instant.MAX)) {
            return Long.MAX_VALUE;
        }
        return instant.toEpochMilli();
    }

    public static ZonedDateTime epochToZonedDateTime(long epochMilliSecond) {
        return Instant.ofEpochMilli(epochMilliSecond).atZone(ZoneOffset.UTC);
    }

    public static Instant epochToInstant(long epochMilliSecond) {
        return Instant.ofEpochMilli(epochMilliSecond);
    }

    public static String format(long epochMilliSecond) {
        return DateTimeUtil.format(epochMilliSecond, FORMATTER);
    }

    public static String format(long epochMilliSecond, DateTimeFormatter formatter) {
        if (epochMilliSecond == Long.MAX_VALUE) {
            return LATEST;
        }
        if (epochMilliSecond == Long.MIN_VALUE) {
            return CANCELED;
        }
        if (epochMilliSecond == PrimitiveData.PREMUNDANE_TIME) {
            return PREMUNDANE;
        }
        ZonedDateTime positionTime = ZonedDateTime.ofInstant(Instant.ofEpochMilli(epochMilliSecond), ZoneOffset.UTC);
        ZonedDateTime inLocalZone = positionTime.withZoneSameInstant(ZoneId.systemDefault());
        return inLocalZone.format(formatter);
    }

    public static String timeNowSimple() {
        return TIME_SIMPLE.format(ZonedDateTime.now());
    }

    public static String nowWithZone() {
        return DateTimeUtil.textFormatWithZone(ZonedDateTime.now());
    }

    public static String textFormatWithZone(ZonedDateTime zonedDateTime) {
        return TEXT_FORMAT_WITH_ZONE.format(zonedDateTime);
    }

    public static long parseWithZone(String dateTime) {
        if (dateTime.equalsIgnoreCase(LATEST)) {
            return Long.MAX_VALUE;
        }
        if (dateTime.equalsIgnoreCase(CANCELED)) {
            return Long.MIN_VALUE;
        }
        if (dateTime.equalsIgnoreCase(PREMUNDANE)) {
            return PrimitiveData.PREMUNDANE_TIME;
        }
        return ZonedDateTime.parse(dateTime, ZONE_FORMATTER).toInstant().toEpochMilli();
    }

    public static long compressedParse(String dateTime) {
        if (dateTime.equalsIgnoreCase(LATEST)) {
            return Long.MAX_VALUE;
        }
        if (dateTime.equalsIgnoreCase(CANCELED)) {
            return Long.MIN_VALUE;
        }
        if (dateTime.equalsIgnoreCase(PREMUNDANE)) {
            return PrimitiveData.PREMUNDANE_TIME;
        }
        return LocalDateTime.parse(dateTime, COMPRESSED_DATE_TIME).atZone(ZoneOffset.UTC).toInstant().toEpochMilli();
    }

    public static long parse(String dateTime) {
        if (dateTime.equalsIgnoreCase(LATEST)) {
            return Long.MAX_VALUE;
        }
        if (dateTime.equalsIgnoreCase(CANCELED)) {
            return Long.MIN_VALUE;
        }
        if (dateTime.equalsIgnoreCase(PREMUNDANE)) {
            return PrimitiveData.PREMUNDANE_TIME;
        }
        return LocalDateTime.parse(dateTime, FORMATTER).atZone(ZoneOffset.UTC).toInstant().toEpochMilli();
    }

    public static String format(Instant instant, DateTimeFormatter formatter) {
        if (instant.equals(Instant.MAX)) {
            return LATEST;
        }
        if (instant.equals(Instant.MIN)) {
            return CANCELED;
        }
        if (instant.equals(PrimitiveData.PREMUNDANE_INSTANT)) {
            return PREMUNDANE;
        }
        return formatter.format(instant);
    }

    public static String format(Instant instant) {
        return DateTimeUtil.format(instant, FORMATTER);
    }

    public static String format(ZonedDateTime zonedDateTime) {
        return zonedDateTime.format(ZONE_FORMATTER);
    }

    public static String format(Instant instant, Double resolution) {
        if (instant.equals(Instant.MAX)) {
            return LATEST;
        }
        if (instant.equals(Instant.MIN)) {
            return CANCELED;
        }
        if (instant.equals(PrimitiveData.PREMUNDANE_INSTANT)) {
            return PREMUNDANE;
        }
        if (resolution < 1000.0) {
            return ZONE_FORMATTER.format(instant);
        }
        if (resolution < 60000.0) {
            return SEC_FORMATTER.format(instant);
        }
        if (resolution < 3600000.0) {
            return MIN_FORMATTER.format(instant);
        }
        if (resolution < 8.64E7) {
            return HOUR_FORMATTER.format(instant);
        }
        if (resolution < 2.592E9) {
            return DAY_FORMATTER.format(instant);
        }
        if (resolution < 3.1536E10) {
            return MONTH_FORMATTER.format(instant);
        }
        return YEAR_FORMATTER.format(instant);
    }

    public static String format(ZonedDateTime zonedDateTime, Double resolution) {
        if (resolution < 1000.0) {
            return zonedDateTime.format(ZONE_FORMATTER);
        }
        if (resolution < 60000.0) {
            return zonedDateTime.format(SEC_FORMATTER);
        }
        if (resolution < 3600000.0) {
            return zonedDateTime.format(MIN_FORMATTER);
        }
        if (resolution < 8.64E7) {
            return zonedDateTime.format(HOUR_FORMATTER);
        }
        if (resolution < 2.592E9) {
            return zonedDateTime.format(DAY_FORMATTER);
        }
        if (resolution < 3.1536E10) {
            return zonedDateTime.format(MONTH_FORMATTER);
        }
        return zonedDateTime.format(YEAR_FORMATTER);
    }

    public static long toEpochMilliseconds(LocalDateTime localDateTime) {
        return localDateTime.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
    }

    public static String getDayOfMonthSuffix(int n) {
        if (n < 1 || n > 31) {
            throw new IllegalArgumentException("illegal day of month: " + n);
        }
        if (n >= 11 && n <= 13) {
            return "th";
        }
        switch (n % 10) {
            case 1: {
                return "st";
            }
            case 2: {
                return "nd";
            }
            case 3: {
                return "rd";
            }
        }
        return "th";
    }
}

