/*
 * Decompiled with CFR 0.152.
 */
package dev.ikm.tinkar.common.util.time;

import java.time.Duration;
import java.util.concurrent.TimeUnit;

public class DurationUtil {
    static final int SECONDS_PER_MINUTE = 60;
    static final int MINUTES_PER_HOUR = 60;
    static final int SECONDS_PER_HOUR = 3600;

    public static String format(Duration d) {
        StringBuilder builder = new StringBuilder();
        long seconds = d.getSeconds();
        if (seconds > 0L) {
            long hours = seconds / 3600L;
            int minutes = (int)(seconds % 3600L / 60L);
            int secs = (int)(seconds % 60L);
            if (hours != 0L) {
                builder.append(hours).append(" h ");
            }
            if (minutes != 0) {
                builder.append(minutes).append(" m ");
            }
            builder.append(secs).append(" s");
            return builder.toString();
        }
        int nanos = d.getNano();
        long milis = TimeUnit.MILLISECONDS.convert(nanos, TimeUnit.NANOSECONDS);
        if (milis > 0L) {
            return builder.append(milis).append(" ms").toString();
        }
        long micro = TimeUnit.MICROSECONDS.convert(nanos, TimeUnit.NANOSECONDS);
        if (micro > 0L) {
            return builder.append(micro).append(" \u03bcs").toString();
        }
        return builder.append(nanos).append(" ns").toString();
    }

    public static String msTo8601(long milliseconds) {
        StringBuilder builder = new StringBuilder();
        builder.append("P");
        boolean addT = true;
        if (milliseconds >= 31536000000L) {
            builder.append(milliseconds / 31536000000L);
            builder.append("Y");
            milliseconds %= 31536000000L;
        }
        if (milliseconds >= 2592000000L) {
            builder.append(milliseconds / 2592000000L);
            builder.append("M");
            milliseconds %= 2592000000L;
        }
        if (milliseconds >= 86400000L) {
            builder.append(milliseconds / 86400000L);
            builder.append("D");
            milliseconds %= 86400000L;
        }
        if (milliseconds >= 3600000L) {
            addT = false;
            builder.append("T");
            builder.append(milliseconds / 3600000L);
            builder.append("H");
            milliseconds %= 3600000L;
        }
        if (milliseconds >= 60000L) {
            if (addT) {
                builder.append("T");
                addT = false;
            }
            builder.append(milliseconds / 60000L);
            builder.append("M");
            milliseconds %= 60000L;
        }
        if (milliseconds >= 1000L) {
            long microseconds = milliseconds % 1000L;
            if (addT) {
                builder.append("T");
                addT = false;
            }
            builder.append(milliseconds / 1000L);
            if (microseconds >= 100L) {
                builder.append(".").append(microseconds);
            } else if (microseconds >= 10L) {
                builder.append(".0").append(microseconds);
            } else if (microseconds > 0L) {
                builder.append("0.00").append(microseconds);
            }
            builder.append("S");
        } else if (milliseconds > 0L) {
            if (addT) {
                builder.append("T");
                addT = false;
            }
            if (milliseconds >= 100L) {
                builder.append("0.").append(milliseconds);
            } else if (milliseconds >= 10L) {
                builder.append("0.0").append(milliseconds);
            } else {
                builder.append("0.00").append(milliseconds);
            }
            builder.append("S");
        }
        return builder.toString();
    }
}

