/*
 * Decompiled with CFR 0.152.
 */
package dev.ikm.tinkar.common.util.time;

import dev.ikm.tinkar.common.util.time.DurationUtil;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.DoubleAdder;
import java.util.concurrent.atomic.LongAdder;

public class MultipleEndpointTimer<T extends Enum<T>> {
    final Class<T> endPointsEnumClass;
    final SumInfo[] sumInfoArray;
    final SumInfo globalInfo = new SumInfo();
    final T[] enums;

    public MultipleEndpointTimer(Class<T> endPointsEnumClass) {
        this.endPointsEnumClass = endPointsEnumClass;
        this.enums = (Enum[])endPointsEnumClass.getEnumConstants();
        this.sumInfoArray = new SumInfo[this.enums.length];
        for (T enumValue : this.enums) {
            this.sumInfoArray[((Enum)enumValue).ordinal()] = new SumInfo();
        }
    }

    public Stopwatch startNew() {
        return new Stopwatch();
    }

    public String progress() {
        StringBuilder sb = new StringBuilder();
        sb.append("Processed ");
        this.appendSumInfo(sb, this.globalInfo);
        sb.append("\n");
        return sb.toString();
    }

    public String summary() {
        StringBuilder sb = new StringBuilder();
        for (T enumValue : this.enums) {
            sb.append(((Enum)enumValue).toString()).append(": ");
            this.appendSumInfo(sb, this.sumInfoArray[((Enum)enumValue).ordinal()]);
            sb.append("\n");
        }
        sb.append("Overall: ");
        this.appendSumInfo(sb, this.globalInfo);
        sb.append("\n");
        return sb.toString();
    }

    private void appendSumInfo(StringBuilder sb, SumInfo sumInfoForEndpoint) {
        Duration minDuration = Duration.ofNanos(sumInfoForEndpoint.min.get());
        Duration maxDuration = Duration.ofNanos(sumInfoForEndpoint.max.get());
        long count = sumInfoForEndpoint.count.sum();
        Duration averageDuration = Duration.ofNanos((long)(sumInfoForEndpoint.sum.sum() / (double)count));
        sb.append(String.format("count: %,d", count));
        sb.append(" min: ").append(DurationUtil.format(minDuration));
        sb.append(" mean: ").append(DurationUtil.format(averageDuration));
        sb.append(" max: ").append(DurationUtil.format(maxDuration));
    }

    private record SumInfo(LongAdder count, DoubleAdder sum, AtomicLong min, AtomicLong max) {
        public SumInfo() {
            this(new LongAdder(), new DoubleAdder(), new AtomicLong(Long.MAX_VALUE), new AtomicLong(Long.MIN_VALUE));
        }

        public void accept(long nanoseconds) {
            this.count.increment();
            this.sum.add(nanoseconds);
            long currentMax = this.max.get();
            while (nanoseconds > currentMax) {
                this.max.compareAndSet(currentMax, nanoseconds);
                currentMax = this.max.get();
            }
            long currentMin = this.min.get();
            while (nanoseconds < currentMin) {
                this.min.compareAndSet(currentMin, nanoseconds);
                currentMin = this.min.get();
            }
        }
    }

    public class Stopwatch {
        private final Instant start = Instant.now();
        private Instant end;

        public Duration end(T endPoint) {
            this.end = Instant.now();
            SumInfo sumInfoForEndpoint = MultipleEndpointTimer.this.sumInfoArray[((Enum)endPoint).ordinal()];
            Duration duration = Duration.between(this.start, this.end);
            long nanoseconds = duration.toNanos();
            sumInfoForEndpoint.accept(nanoseconds);
            MultipleEndpointTimer.this.globalInfo.accept(nanoseconds);
            return duration;
        }

        public Duration end() {
            this.end = Instant.now();
            Duration duration = Duration.between(this.start, this.end);
            MultipleEndpointTimer.this.globalInfo.accept(duration.toNanos());
            return duration;
        }
    }
}

