/*
 * Decompiled with CFR 0.152.
 */
package dev.ikm.tinkar.common.util.time;

import dev.ikm.tinkar.common.util.time.DurationUtil;
import java.time.Duration;
import java.time.Instant;

public class Stopwatch {
    private Instant startTime;
    private Instant lastUpdate;
    private Instant endTime;
    private Duration updateInterval = Duration.ofMillis(100L);

    public Stopwatch() {
        this.lastUpdate = this.startTime = Instant.now();
    }

    public Stopwatch(Duration updateInterval) {
        this.lastUpdate = this.startTime = Instant.now();
        this.updateInterval = updateInterval;
    }

    public void end() {
        this.endTime = Instant.now();
    }

    public void reset() {
        this.startTime = Instant.now();
    }

    public void stop() {
        this.endTime = Instant.now();
    }

    public boolean updateIntervalElapsed() {
        Instant now = Instant.now();
        if (this.updateInterval.compareTo(Duration.between(this.lastUpdate, now)) < 0) {
            this.lastUpdate = now;
            return true;
        }
        return false;
    }

    public String durationString() {
        return DurationUtil.format(this.duration());
    }

    public Duration duration() {
        Instant endForDuration = this.endTime;
        if (endForDuration == null) {
            endForDuration = Instant.now();
        }
        return Duration.between(this.startTime, endForDuration);
    }

    public String averageDurationForElementString(int count) {
        return DurationUtil.format(this.averageDurationForElement(count));
    }

    public Duration averageDurationForElement(int count) {
        Duration entireDuration;
        Instant endForDuration = this.endTime;
        if (endForDuration == null) {
            endForDuration = Instant.now();
        }
        Duration average = entireDuration = Duration.between(this.startTime, endForDuration);
        if (count > 0) {
            average = entireDuration.dividedBy(count);
        }
        return average;
    }
}

