/*
 * Decompiled with CFR 0.152.
 */
package dev.ikm.tinkar.common.util.uuid;

import dev.ikm.tinkar.common.id.PublicId;
import dev.ikm.tinkar.common.util.uuid.UuidUtil;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.UUID;
import java.util.function.BiConsumer;

public class UuidT5Generator {
    public static final String ENCODING = "UTF-8";
    public static final String DIGEST = "SHA-1";
    public static final UUID STAMP_NAMESPACE = UUID.fromString("2801b388-44aa-11eb-b378-0242ac130002");
    public static final UUID PATH_ID_FROM_FS_DESC = UUID.fromString("5a2e7786-3e41-11dc-8314-0800200c9a66");
    public static final UUID REL_GROUP_NAMESPACE = UUID.fromString("8972fef0-ad53-11df-94e2-0800200c9a66");
    public static final UUID USER_FULLNAME_NAMESPACE = UUID.fromString("cad85220-1ed4-11e1-8bc2-0800200c9a66");
    public static final UUID TAXONOMY_COORDINATE_NAMESPACE = UUID.fromString("c58dcdb6-185b-11e5-b60b-1697f925ec7b");
    public static final UUID REL_ADAPTOR_NAMESPACE = UUID.fromString("9cb2bf66-1863-11e5-b60b-1697f925ec7");
    public static final UUID AUTHOR_TIME_ID = UUID.fromString("c6915290-30fc-11e1-b86c-0800200c9a66");
    public static final UUID SINGLE_SEMANTIC_FOR_RC_UUID = UUID.fromString("97c14234-205f-11eb-adc1-0242ac120002");

    private UuidT5Generator() {
    }

    public static UUID singleSemanticUuid(PublicId patternId, PublicId referencedComponentId) {
        return UuidT5Generator.singleSemanticUuid(patternId.asUuidArray(), referencedComponentId.asUuidArray());
    }

    public static UUID singleSemanticUuid(UUID[] patternUuids, UUID[] referencedComponentIds) {
        Arrays.sort(patternUuids);
        Arrays.sort(referencedComponentIds);
        StringBuilder builder = new StringBuilder();
        builder.append(Arrays.toString(patternUuids));
        builder.append(Arrays.toString(referencedComponentIds));
        return UuidT5Generator.get(SINGLE_SEMANTIC_FOR_RC_UUID, builder.toString());
    }

    public static UUID get(UUID namespace, String name) {
        return UuidT5Generator.getUuidWithEncoding(namespace, name, ENCODING);
    }

    public static UUID getUuidWithEncoding(UUID namespace, String name, String encoding) {
        try {
            int i;
            MessageDigest sha1Algorithm = UuidT5Generator.getDigest(DIGEST);
            sha1Algorithm.reset();
            if (namespace != null) {
                sha1Algorithm.update(UuidUtil.getRawBytes(namespace));
            }
            sha1Algorithm.update(name.getBytes(encoding));
            byte[] sha1digest = sha1Algorithm.digest();
            sha1digest[6] = (byte)(sha1digest[6] & 0xF);
            sha1digest[6] = (byte)(sha1digest[6] | 0x50);
            sha1digest[8] = (byte)(sha1digest[8] & 0x3F);
            sha1digest[8] = (byte)(sha1digest[8] | 0x80);
            long msb = 0L;
            long lsb = 0L;
            for (i = 0; i < 8; ++i) {
                msb = msb << 8 | (long)(sha1digest[i] & 0xFF);
            }
            for (i = 8; i < 16; ++i) {
                lsb = lsb << 8 | (long)(sha1digest[i] & 0xFF);
            }
            return new UUID(msb, lsb);
        }
        catch (UnsupportedEncodingException ex) {
            throw new UnsupportedOperationException(ex);
        }
    }

    public static MessageDigest getDigest(String instance) {
        try {
            return MessageDigest.getInstance(instance);
        }
        catch (NoSuchAlgorithmException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    public static UUID fromPublicIds(PublicId id1, PublicId id2) {
        StringBuilder builder = new StringBuilder();
        UuidT5Generator.addPublicId(builder, id1);
        UuidT5Generator.addPublicId(builder, id2);
        return UuidT5Generator.get(builder.toString());
    }

    private static void addPublicId(StringBuilder builder, PublicId publicId) {
        Object[] publicUuids = publicId.asUuidArray();
        Arrays.sort(publicUuids);
        for (Object uuid : publicUuids) {
            builder.append(((UUID)uuid).toString());
        }
    }

    public static UUID get(String name) {
        return UuidT5Generator.get(null, name);
    }

    public static UUID fromPublicIds(UUID namespace, PublicId ... publicIds) {
        StringBuilder builder = new StringBuilder();
        for (PublicId publicId : publicIds) {
            UuidT5Generator.addPublicId(builder, publicId);
        }
        return UuidT5Generator.get(namespace, builder.toString());
    }

    public static UUID forTransaction(UUID transactionId, PublicId stateId, long time, PublicId authorId, PublicId moduleId, PublicId pathId) {
        StringBuilder builder = new StringBuilder();
        UuidT5Generator.addPublicId(builder, stateId);
        UuidT5Generator.addPublicId(builder, authorId);
        UuidT5Generator.addPublicId(builder, moduleId);
        UuidT5Generator.addPublicId(builder, pathId);
        builder.append(time);
        return UuidT5Generator.get(transactionId, builder.toString());
    }

    public static UUID get(UUID namespace, String name, BiConsumer<String, UUID> consumer) {
        UUID temp = UuidT5Generator.get(namespace, name);
        if (consumer != null) {
            consumer.accept(name, temp);
        }
        return temp;
    }
}

