/*
 * Decompiled with CFR 0.152.
 */
package dev.ikm.tinkar.common.util.uuid;

import dev.ikm.tinkar.common.id.PublicId;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import java.util.UUID;
import org.eclipse.collections.api.factory.Lists;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.api.list.ListIterable;
import org.eclipse.collections.api.list.MutableList;

public class UuidUtil {
    public static final String ENCODING_FOR_UUID_GENERATION = "8859_1";
    public static final UUID NIL_UUID = UUID.fromString("00000000-0000-0000-0000-000000000000");

    private UuidUtil() {
    }

    public static boolean isUUID(String string) {
        return UuidUtil.getUUID(string).isPresent();
    }

    public static Optional<UUID> getUUID(String string) {
        if (string == null) {
            return Optional.empty();
        }
        if (string.length() != 36) {
            return Optional.empty();
        }
        try {
            return Optional.of(UUID.fromString(string));
        }
        catch (IllegalArgumentException e) {
            return Optional.empty();
        }
    }

    public static UUID fromList(UUID ... uuids) {
        ArrayList<String> uuidStrList = new ArrayList<String>();
        for (UUID uuid : uuids) {
            uuidStrList.add(uuid.toString());
        }
        uuidStrList.sort((o1, o2) -> o1.compareTo((String)o2));
        StringBuilder buff = new StringBuilder();
        for (String uuidStr : uuidStrList) {
            buff.append(uuidStr);
        }
        return UUID.nameUUIDFromBytes(buff.toString().getBytes());
    }

    public static long[] asArray(UUID uuid) {
        return new long[]{uuid.getMostSignificantBits(), uuid.getLeastSignificantBits()};
    }

    public static long[] asArray(UUID ... uuids) {
        Arrays.sort(uuids);
        long[] values = new long[uuids.length * 2];
        for (int i = 0; i < uuids.length; ++i) {
            values[i * 2] = uuids[i].getMostSignificantBits();
            values[i * 2 + 1] = uuids[i].getLeastSignificantBits();
        }
        return values;
    }

    public static long[] asArray(ListIterable<UUID> uuidList) {
        uuidList = uuidList.toSortedList();
        int size = uuidList.size();
        long[] values = new long[size * 2];
        for (int i = 0; i < size; ++i) {
            UUID uuid = (UUID)uuidList.get(i);
            values[i * 2] = uuid.getMostSignificantBits();
            values[i * 2 + 1] = uuid.getLeastSignificantBits();
        }
        return values;
    }

    public static UUID fromArray(long[] array) {
        return new UUID(array[0], array[1]);
    }

    public static ImmutableList<UUID> toList(long[] array) {
        MutableList uuidList = Lists.mutable.ofInitialCapacity(array.length / 2);
        for (int i = 0; i < array.length / 2; ++i) {
            uuidList.add((Object)new UUID(array[i * 2], array[i * 2 + 1]));
        }
        return uuidList.toImmutable();
    }

    public static UUID[] toArray(long[] array) {
        UUID[] uuidArray = new UUID[array.length / 2];
        for (int i = 0; i < array.length / 2; ++i) {
            uuidArray[i] = new UUID(array[i * 2], array[i * 2 + 1]);
        }
        return uuidArray;
    }

    public static byte[] getRawBytes(UUID uuid) {
        long hi = uuid.getMostSignificantBits();
        long lo = uuid.getLeastSignificantBits();
        byte[] result = new byte[16];
        UuidUtil.appendInt((int)(hi >> 32), result, 0);
        UuidUtil.appendInt((int)hi, result, 4);
        UuidUtil.appendInt((int)(lo >> 32), result, 8);
        UuidUtil.appendInt((int)lo, result, 12);
        return result;
    }

    private static final void appendInt(int value, byte[] buffer, int offset) {
        buffer[offset++] = (byte)(value >> 24);
        buffer[offset++] = (byte)(value >> 16);
        buffer[offset++] = (byte)(value >> 8);
        buffer[offset] = (byte)value;
    }

    public static UUID getUuidFromRawBytes(byte[] byteArray) {
        if (byteArray.length != 16) {
            throw new NumberFormatException("UUID must be 16 bytes");
        }
        ByteBuffer raw = ByteBuffer.wrap(byteArray);
        return new UUID(raw.getLong(raw.position()), raw.getLong(raw.position() + 8));
    }

    public static String toString(Iterable<UUID> uuids) {
        StringBuilder sb = new StringBuilder("[");
        boolean i = false;
        for (UUID uuid : uuids) {
            sb.append(uuid.toString());
        }
        sb.append(", ");
        sb.deleteCharAt(sb.length() - 1);
        sb.append("]");
        return sb.toString();
    }

    public static String toString(PublicId publicId) {
        return UuidUtil.toString(publicId.asUuidArray());
    }

    public static String toString(UUID ... uuids) {
        StringBuilder sb = new StringBuilder("[");
        for (int i = 0; i < uuids.length; ++i) {
            sb.append(uuids[i].toString());
            if (i >= uuids.length - 1) continue;
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }

    public static UUID[] fromString(String uuidListString) {
        String[] elements = uuidListString.substring(uuidListString.indexOf(91) + 1, uuidListString.indexOf(93)).split(",");
        UUID[] uuids = new UUID[elements.length];
        for (int i = 0; i < elements.length; ++i) {
            if (elements[i].trim().length() > 36) {
                throw new IllegalArgumentException("UUID string too large: " + elements[i].trim());
            }
            uuids[i] = UUID.fromString(elements[i].trim());
        }
        return uuids;
    }

    public static UUID fromSNOMED(String id) {
        String name = "org.snomed." + id;
        try {
            return UUID.nameUUIDFromBytes(name.getBytes(ENCODING_FOR_UUID_GENERATION));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

