/*
 * Decompiled with CFR 0.152.
 */
package dev.ikm.tinkar.provider.spinedarray;

import dev.ikm.tinkar.collection.store.ByteArrayArrayStore;
import dev.ikm.tinkar.provider.spinedarray.SpinedArrayFileStore;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ByteArrayArrayFileStore
extends SpinedArrayFileStore
implements ByteArrayArrayStore {
    private static final Logger LOG = LoggerFactory.getLogger(ByteArrayArrayFileStore.class);

    public ByteArrayArrayFileStore(File directory) {
        super(directory);
    }

    public ByteArrayArrayFileStore(File directory, Semaphore diskSemaphore) {
        super(directory, diskSemaphore);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<AtomicReferenceArray<byte[][]>> get(int spineIndex) {
        String spineKey = "spine-" + spineIndex;
        File spineFile = new File(this.directory, spineKey);
        if (spineFile.exists()) {
            Optional<AtomicReferenceArray<byte[][]>> optional;
            this.diskSemaphore.acquireUninterruptibly();
            DataInputStream dis = new DataInputStream(new BufferedInputStream(new FileInputStream(spineFile)));
            try {
                int arraySize = dis.readInt();
                byte[][][] spineArray = new byte[arraySize][][];
                for (int i = 0; i < arraySize; ++i) {
                    int valueSize = dis.readInt();
                    if (valueSize == 0) continue;
                    byte[][] value = new byte[valueSize][];
                    for (int j = 0; j < valueSize; ++j) {
                        int valuePartSize = dis.readInt();
                        byte[] valuePart = new byte[valuePartSize];
                        dis.readFully(valuePart);
                        value[j] = valuePart;
                    }
                    spineArray[i] = value;
                }
                AtomicReferenceArray spine = new AtomicReferenceArray((E[])spineArray);
                optional = Optional.of(spine);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        try {
                            dis.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (IOException ex) {
                        LOG.error(ex.getLocalizedMessage(), (Throwable)ex);
                        this.diskSemaphore.release();
                    }
                }
                catch (Throwable throwable3) {
                    this.diskSemaphore.release();
                    throw throwable3;
                }
            }
            dis.close();
            this.diskSemaphore.release();
            return optional;
        }
        return Optional.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(int spineIndex, AtomicReferenceArray<byte[][]> spine) {
        String spineKey = "spine-" + spineIndex;
        File spineFile = new File(this.directory, spineKey);
        this.diskSemaphore.acquireUninterruptibly();
        try (DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(spineFile)));){
            dos.writeInt(spine.length());
            for (int i = 0; i < spine.length(); ++i) {
                byte[][] value = spine.get(i);
                if (value == null) {
                    dos.writeInt(0);
                    continue;
                }
                dos.writeInt(value.length);
                for (byte[] valuePart : value) {
                    dos.writeInt(valuePart.length);
                    dos.write(valuePart);
                }
            }
        }
        catch (IOException ex) {
            LOG.error(ex.getLocalizedMessage(), (Throwable)ex);
        }
        finally {
            this.diskSemaphore.release();
        }
    }
}

