/*
 * Decompiled with CFR 0.152.
 */
package dev.ikm.tinkar.provider.spinedarray;

import dev.ikm.tinkar.collection.store.IntIntArrayStore;
import dev.ikm.tinkar.provider.spinedarray.SpinedArrayFileStore;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IntIntArrayFileStore
extends SpinedArrayFileStore
implements IntIntArrayStore {
    private static final Logger LOG = LoggerFactory.getLogger(IntIntArrayFileStore.class);

    public IntIntArrayFileStore(File directory) {
        super(directory);
    }

    public IntIntArrayFileStore(File directory, Semaphore diskSemaphore) {
        super(directory, diskSemaphore);
    }

    public Optional<AtomicReferenceArray<int[]>> get(int spineIndex) {
        Optional<AtomicReferenceArray<int[]>> optional;
        String spineKey = "spine-" + spineIndex;
        File spineFile = new File(this.directory, spineKey);
        if (!spineFile.exists()) {
            return Optional.empty();
        }
        DataInputStream dis = new DataInputStream(new BufferedInputStream(new FileInputStream(spineFile)));
        try {
            int arraySize = dis.readInt();
            AtomicReferenceArray<int[]> data = new AtomicReferenceArray<int[]>(arraySize);
            for (int i = 0; i < arraySize; ++i) {
                int valueSize = dis.readInt();
                if (valueSize == 0) continue;
                int[] value = new int[valueSize];
                for (int j = 0; j < valueSize; ++j) {
                    value[j] = dis.readInt();
                }
                data.set(i, value);
            }
            optional = Optional.of(data);
        }
        catch (Throwable throwable) {
            try {
                try {
                    dis.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                LOG.error(ex.getLocalizedMessage(), (Throwable)ex);
                throw new RuntimeException(ex);
            }
        }
        dis.close();
        return optional;
    }

    public void put(int spineIndex, AtomicReferenceArray<int[]> spine) {
        this.directory.mkdirs();
        String spineKey = "spine-" + spineIndex;
        File spineFile = new File(this.directory, spineKey);
        this.diskSemaphore.acquireUninterruptibly();
        try (DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(spineFile)));){
            dos.writeInt(spine.length());
            for (int i = 0; i < spine.length(); ++i) {
                int[] value = spine.get(i);
                if (value == null) {
                    dos.writeInt(0);
                    continue;
                }
                dos.writeInt(value.length);
                for (int valueElement : value) {
                    dos.writeInt(valueElement);
                }
            }
        }
        catch (IOException ex) {
            LOG.error(ex.getLocalizedMessage(), (Throwable)ex);
            throw new RuntimeException(ex);
        }
        finally {
            this.diskSemaphore.release();
        }
    }
}

