/*
 * Decompiled with CFR 0.152.
 */
package dev.ikm.tinkar.provider.spinedarray;

import dev.ikm.tinkar.provider.spinedarray.IntIntArrayFileStore;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Set;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.impl.map.mutable.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IntIntSetFileStore {
    private static final Logger LOG = LoggerFactory.getLogger(IntIntArrayFileStore.class);
    final File patternToElementNidsMapDirectory;
    final File patternToElementNidsMapData;
    ConcurrentHashMap<Integer, ConcurrentHashMap<Integer, Integer>> patternElementNidsMap = ConcurrentHashMap.newMap();

    public IntIntSetFileStore(File patternToElementNidsMapDirectory) {
        this.patternToElementNidsMapDirectory = patternToElementNidsMapDirectory;
        this.patternToElementNidsMapData = new File(patternToElementNidsMapDirectory, "data");
    }

    public void read() throws IOException {
        if (this.patternToElementNidsMapData.exists()) {
            try (DataInputStream dis = new DataInputStream(new BufferedInputStream(new FileInputStream(this.patternToElementNidsMapData)));){
                int patternKeyCount = dis.readInt();
                this.patternElementNidsMap = ConcurrentHashMap.newMap((int)patternKeyCount);
                for (int patternCount = 0; patternCount < patternKeyCount; ++patternCount) {
                    int patternNid = dis.readInt();
                    int elementNidCount = dis.readInt();
                    ConcurrentHashMap elementNidSet = ConcurrentHashMap.newMap((int)elementNidCount);
                    for (int elementCount = 0; elementCount < elementNidCount; ++elementCount) {
                        int elementNid = dis.readInt();
                        elementNidSet.put((Object)elementNid, (Object)elementNid);
                    }
                    this.patternElementNidsMap.put((Object)patternNid, (Object)elementNidSet);
                }
            }
        }
    }

    public void write() throws IOException {
        this.patternToElementNidsMapData.getParentFile().mkdirs();
        try (DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this.patternToElementNidsMapData)));){
            dos.writeInt(this.patternElementNidsMap.size());
            for (Pair keyValue : this.patternElementNidsMap.keyValuesView()) {
                dos.writeInt((Integer)keyValue.getOne());
                dos.writeInt(((ConcurrentHashMap)keyValue.getTwo()).size());
                for (Integer elementNid : ((ConcurrentHashMap)keyValue.getTwo()).keySet()) {
                    dos.writeInt(elementNid);
                }
            }
        }
    }

    public boolean addToSet(int patternNid, int elementNid) {
        return null == ((ConcurrentHashMap)this.patternElementNidsMap.getIfAbsentPut((Object)patternNid, (Function & Serializable)integer -> new ConcurrentHashMap())).put((Object)elementNid, (Object)elementNid);
    }

    public Set<Integer> getElementNidsForPatternNid(int patternNid) {
        if (this.patternElementNidsMap.containsKey((Object)patternNid)) {
            return ((ConcurrentHashMap)this.patternElementNidsMap.get((Object)patternNid)).keySet();
        }
        return Set.of();
    }
}

