/*
 * Decompiled with CFR 0.152.
 */
package dev.ikm.tinkar.provider.spinedarray;

import dev.ikm.tinkar.collection.store.IntLongArrayStore;
import dev.ikm.tinkar.provider.spinedarray.SpinedArrayFileStore;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IntLongArrayFileStore
extends SpinedArrayFileStore
implements IntLongArrayStore {
    private static final Logger LOG = LoggerFactory.getLogger(IntLongArrayFileStore.class);

    public IntLongArrayFileStore(File directory) {
        super(directory);
    }

    public IntLongArrayFileStore(File directory, Semaphore diskSemaphore) {
        super(directory, diskSemaphore);
    }

    public Optional<AtomicReferenceArray<long[]>> get(int spineIndex) {
        Optional<AtomicReferenceArray<long[]>> optional;
        String spineKey = "spine-" + spineIndex;
        File spineFile = new File(this.directory, spineKey);
        if (!spineFile.exists()) {
            return Optional.empty();
        }
        DataInputStream dis = new DataInputStream(new BufferedInputStream(new FileInputStream(spineFile)));
        try {
            int arraySize = dis.readInt();
            AtomicReferenceArray<long[]> data = new AtomicReferenceArray<long[]>(arraySize);
            for (int i = 0; i < arraySize; ++i) {
                int valueSize = dis.readInt();
                if (valueSize == 0) continue;
                long[] value = new long[valueSize];
                for (int j = 0; j < valueSize; ++j) {
                    value[j] = dis.readLong();
                }
                data.set(i, value);
            }
            optional = Optional.of(data);
        }
        catch (Throwable throwable) {
            try {
                try {
                    dis.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                LOG.error(ex.getLocalizedMessage(), (Throwable)ex);
                throw new RuntimeException(ex);
            }
        }
        dis.close();
        return optional;
    }

    public void put(int spineIndex, AtomicReferenceArray<long[]> spine) {
        this.directory.mkdirs();
        String spineKey = "spine-" + spineIndex;
        File spineFile = new File(this.directory, spineKey);
        this.diskSemaphore.acquireUninterruptibly();
        try (DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(spineFile)));){
            dos.writeInt(spine.length());
            for (int i = 0; i < spine.length(); ++i) {
                long[] value = spine.get(i);
                if (value == null) {
                    dos.writeInt(0);
                    continue;
                }
                dos.writeInt(value.length);
                for (long valueElement : value) {
                    dos.writeLong(valueElement);
                }
            }
        }
        catch (IOException ex) {
            LOG.error(ex.getLocalizedMessage(), (Throwable)ex);
            throw new RuntimeException(ex);
        }
        finally {
            this.diskSemaphore.release();
        }
    }
}

