/*
 * Decompiled with CFR 0.152.
 */
package dev.ikm.tinkar.provider.spinedarray;

import dev.ikm.tinkar.collection.SpineFileUtil;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.Semaphore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpinedArrayFileStore {
    private static final Logger LOG = LoggerFactory.getLogger(SpinedArrayFileStore.class);
    protected final Semaphore diskSemaphore;
    protected final File directory;
    protected int spineSize;

    public SpinedArrayFileStore(File directory) {
        this(directory, new Semaphore(1));
    }

    public SpinedArrayFileStore(File directory, Semaphore diskSemaphore) {
        this.directory = directory;
        this.directory.mkdirs();
        this.spineSize = SpineFileUtil.readSpineCount((File)directory);
        this.diskSemaphore = diskSemaphore;
    }

    public final void writeSpineCount(int spineCount) {
        try {
            this.spineSize = spineCount;
            SpineFileUtil.writeSpineCount((File)this.directory, (int)spineCount);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public final int getSpineCount() {
        return SpineFileUtil.readSpineCount((File)this.directory);
    }

    public final int sizeOnDisk() {
        if (this.directory == null) {
            return 0;
        }
        File[] files = this.directory.listFiles(pathname -> pathname.getName().startsWith("spine-"));
        int size = 0;
        for (File spineFile : files) {
            size = (int)((long)size + spineFile.length());
        }
        return size;
    }
}

