/*
 * Decompiled with CFR 0.152.
 */
package dev.ikm.tinkar.provider.spinedarray;

import com.google.auto.service.AutoService;
import dev.ikm.tinkar.common.service.DataServiceController;
import dev.ikm.tinkar.common.service.DataServiceProperty;
import dev.ikm.tinkar.common.service.DataUriOption;
import dev.ikm.tinkar.common.service.LoadDataFromFileController;
import dev.ikm.tinkar.common.service.ServiceKeys;
import dev.ikm.tinkar.common.service.ServiceProperties;
import dev.ikm.tinkar.common.validation.ValidationRecord;
import dev.ikm.tinkar.common.validation.ValidationSeverity;
import dev.ikm.tinkar.provider.spinedarray.SpinedArrayController;
import dev.ikm.tinkar.provider.spinedarray.SpinedArrayProvider;
import dev.ikm.tinkar.provider.spinedarray.internal.Get;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.eclipse.collections.api.factory.Maps;
import org.eclipse.collections.api.map.ImmutableMap;
import org.eclipse.collections.api.map.MutableMap;

@AutoService(value={DataServiceController.class})
public class SpinedArrayNewController
extends SpinedArrayController {
    public static boolean loading = false;
    public static String CONTROLLER_NAME = "New Spined Array Store";
    String importDataFileString;
    DataServiceProperty newFolderProperty = new DataServiceProperty("New folder name", false, true);
    MutableMap<DataServiceProperty, String> providerProperties = Maps.mutable.empty();

    public SpinedArrayNewController() {
        this.providerProperties.put((Object)this.newFolderProperty, null);
    }

    public ImmutableMap<DataServiceProperty, String> providerProperties() {
        return this.providerProperties.toImmutable();
    }

    public void setDataServiceProperty(DataServiceProperty key, String value) {
        this.providerProperties.put((Object)key, (Object)value);
    }

    public ValidationRecord[] validate(DataServiceProperty dataServiceProperty, Object value, Object target) {
        if (this.newFolderProperty.equals((Object)dataServiceProperty)) {
            File rootFolder = new File(System.getProperty("user.home"), "Solor");
            if (value instanceof String) {
                String fileName = (String)value;
                if (fileName.isBlank()) {
                    return new ValidationRecord[]{new ValidationRecord(ValidationSeverity.ERROR, "Directory name cannot be blank", target)};
                }
                File possibleFile = new File(rootFolder, fileName);
                if (possibleFile.exists()) {
                    return new ValidationRecord[]{new ValidationRecord(ValidationSeverity.ERROR, "Directory already exists", target)};
                }
            }
        }
        return new ValidationRecord[0];
    }

    public List<DataUriOption> providerOptions() {
        ArrayList<DataUriOption> dataUriOptions = new ArrayList<DataUriOption>();
        File rootFolder = new File(System.getProperty("user.home"), "Solor");
        if (!rootFolder.exists()) {
            rootFolder.mkdirs();
        }
        for (File f : rootFolder.listFiles()) {
            if (!this.isValidDataLocation(f.getName())) continue;
            dataUriOptions.add(new DataUriOption(f.getName(), f.toURI()));
        }
        return dataUriOptions;
    }

    public boolean isValidDataLocation(String name) {
        return name.toLowerCase().endsWith(".zip") && name.toLowerCase().contains("tink");
    }

    public void setDataUriOption(DataUriOption option) {
        try {
            this.importDataFileString = option.uri().toURL().getFile();
        }
        catch (MalformedURLException e) {
            throw new UncheckedIOException(e);
        }
    }

    public String controllerName() {
        return CONTROLLER_NAME;
    }

    @Override
    public void start() {
        if (SpinedArrayProvider.singleton == null) {
            loading = true;
            try {
                File rootFolder = new File(System.getProperty("user.home"), "Solor");
                File dataDirectory = new File(rootFolder, (String)this.providerProperties.get((Object)this.newFolderProperty));
                ServiceProperties.set((Enum)ServiceKeys.DATA_STORE_ROOT, (Object)dataDirectory);
                new SpinedArrayProvider();
                ServiceLoader<LoadDataFromFileController> controllerFinder = ServiceLoader.load(LoadDataFromFileController.class);
                LoadDataFromFileController loader = controllerFinder.findFirst().get();
                Future loadFuture = loader.load(new File(this.importDataFileString));
                int count = (Integer)loadFuture.get();
                Get.singleton.save();
            }
            catch (IOException | InterruptedException | ExecutionException e) {
                e.printStackTrace();
            }
            loading = false;
        }
    }

    public boolean loading() {
        return loading;
    }
}

