/*
 * Decompiled with CFR 0.152.
 */
package dev.ikm.tinkar.provider.spinedarray;

import dev.ikm.tinkar.collection.KeyType;
import dev.ikm.tinkar.collection.SpinedByteArrayMap;
import dev.ikm.tinkar.collection.SpinedIntIntMap;
import dev.ikm.tinkar.collection.SpinedIntLongArrayMap;
import dev.ikm.tinkar.collection.store.ByteArrayStore;
import dev.ikm.tinkar.collection.store.IntLongArrayStore;
import dev.ikm.tinkar.common.alert.AlertStreams;
import dev.ikm.tinkar.common.id.PublicId;
import dev.ikm.tinkar.common.service.NidGenerator;
import dev.ikm.tinkar.common.service.PrimitiveData;
import dev.ikm.tinkar.common.service.PrimitiveDataRepair;
import dev.ikm.tinkar.common.service.PrimitiveDataSearchResult;
import dev.ikm.tinkar.common.service.PrimitiveDataService;
import dev.ikm.tinkar.common.service.ServiceKeys;
import dev.ikm.tinkar.common.service.ServiceProperties;
import dev.ikm.tinkar.common.service.TinkExecutor;
import dev.ikm.tinkar.common.sets.ConcurrentHashSet;
import dev.ikm.tinkar.common.util.ints2long.IntsInLong;
import dev.ikm.tinkar.common.util.time.Stopwatch;
import dev.ikm.tinkar.common.util.uuid.UuidUtil;
import dev.ikm.tinkar.entity.ConceptEntity;
import dev.ikm.tinkar.entity.Entity;
import dev.ikm.tinkar.entity.EntityService;
import dev.ikm.tinkar.entity.PatternEntity;
import dev.ikm.tinkar.entity.SemanticEntity;
import dev.ikm.tinkar.entity.StampEntity;
import dev.ikm.tinkar.entity.StampRecord;
import dev.ikm.tinkar.entity.StampVersionRecord;
import dev.ikm.tinkar.entity.transaction.Transaction;
import dev.ikm.tinkar.provider.search.Indexer;
import dev.ikm.tinkar.provider.search.Searcher;
import dev.ikm.tinkar.provider.spinedarray.ByteArrayFileStore;
import dev.ikm.tinkar.provider.spinedarray.IntLongArrayFileStore;
import dev.ikm.tinkar.provider.spinedarray.UuidNidCollector;
import dev.ikm.tinkar.provider.spinedarray.internal.Get;
import dev.ikm.tinkar.provider.spinedarray.internal.Put;
import dev.ikm.tinkar.terms.State;
import io.activej.bytebuf.ByteBuf;
import io.activej.bytebuf.ByteBufPool;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.ObjIntConsumer;
import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.procedure.primitive.IntProcedure;
import org.eclipse.collections.api.factory.Lists;
import org.eclipse.collections.api.factory.Sets;
import org.eclipse.collections.api.factory.primitive.LongSets;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.list.primitive.ImmutableIntList;
import org.eclipse.collections.api.list.primitive.MutableIntList;
import org.eclipse.collections.api.list.primitive.MutableLongList;
import org.eclipse.collections.api.set.MutableSet;
import org.eclipse.collections.api.set.primitive.IntSet;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.factory.primitive.IntLists;
import org.eclipse.collections.impl.factory.primitive.IntSets;
import org.eclipse.collections.impl.factory.primitive.LongLists;
import org.eclipse.collections.impl.map.mutable.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpinedArrayProvider
implements PrimitiveDataService,
NidGenerator,
PrimitiveDataRepair {
    private static final Logger LOG = LoggerFactory.getLogger(SpinedArrayProvider.class);
    protected static final File defaultDataDirectory = new File("target/spinedarrays/");
    protected static SpinedArrayProvider singleton;
    protected static LongAdder writeSequence;
    protected final CountDownLatch uuidsLoadedLatch = new CountDownLatch(1);
    final AtomicInteger nextNid = new AtomicInteger(-2147483647);
    final ConcurrentHashMap<UUID, Integer> uuidToNidMap = ConcurrentHashMap.newMap();
    final ConcurrentHashSet<Integer> patternNids = new ConcurrentHashSet();
    final ConcurrentHashSet<Integer> conceptNids = new ConcurrentHashSet();
    final ConcurrentHashSet<Integer> semanticNids = new ConcurrentHashSet();
    final ConcurrentHashSet<Integer> stampNids = new ConcurrentHashSet();
    final ConcurrentHashMap<Integer, ConcurrentHashSet<Integer>> patternElementNidsMap = ConcurrentHashMap.newMap();
    final SpinedByteArrayMap entityToBytesMap;
    final SpinedIntIntMap nidToPatternNidMap;
    final SpinedIntLongArrayMap nidToCitingComponentsNidMap;
    final File nidToPatternNidMapDirectory;
    final File nidToByteArrayMapDirectory;
    final File nidToCitingComponentNidMapDirectory;
    final File nextNidKeyFile;
    final Indexer indexer;
    final Searcher searcher;
    final String name;

    public SpinedArrayProvider() throws IOException {
        Stopwatch stopwatch = new Stopwatch();
        LOG.info("Opening SpinedArrayProvider");
        File configuredRoot = (File)ServiceProperties.get((Enum)ServiceKeys.DATA_STORE_ROOT, (Object)defaultDataDirectory);
        this.name = configuredRoot.getName();
        configuredRoot.mkdirs();
        File indexDir = new File(configuredRoot, "lucene");
        this.indexer = new Indexer(indexDir.toPath());
        this.searcher = new Searcher();
        singleton = this;
        Get.singleton = this;
        Put.singleton = this;
        this.nidToPatternNidMapDirectory = new File(configuredRoot, "nidToPatternNidMap");
        this.nidToPatternNidMapDirectory.mkdirs();
        this.nidToByteArrayMapDirectory = new File(configuredRoot, "nidToByteArrayMap");
        this.nidToByteArrayMapDirectory.mkdirs();
        this.nidToCitingComponentNidMapDirectory = new File(configuredRoot, "nidToCitingComponentNidMap");
        this.nidToCitingComponentNidMapDirectory.mkdirs();
        this.nextNidKeyFile = new File(configuredRoot, "nextNidKeyFile");
        this.entityToBytesMap = new SpinedByteArrayMap((ByteArrayStore)new ByteArrayFileStore(this.nidToByteArrayMapDirectory));
        this.nidToPatternNidMap = new SpinedIntIntMap(KeyType.NID_KEY);
        this.nidToPatternNidMap.read(this.nidToPatternNidMapDirectory);
        this.nidToCitingComponentsNidMap = new SpinedIntLongArrayMap((IntLongArrayStore)new IntLongArrayFileStore(this.nidToCitingComponentNidMapDirectory));
        if (this.nextNidKeyFile.exists()) {
            String nextNidString = Files.readString(this.nextNidKeyFile.toPath());
            this.nextNid.set(Integer.valueOf(nextNidString));
        }
        TinkExecutor.threadPool().execute(() -> {
            Stopwatch uuidNidMapFromEntitiesStopwatch = new Stopwatch();
            LOG.info("Starting UUID strategy 2");
            UuidNidCollector uuidNidCollector = new UuidNidCollector(this.uuidToNidMap, this.patternNids, this.conceptNids, this.semanticNids, this.stampNids, this.patternElementNidsMap);
            try {
                this.entityToBytesMap.forEachParallel((ObjIntConsumer)uuidNidCollector);
                this.uuidsLoadedLatch.countDown();
                this.listAndCancelUncommittedStamps();
            }
            catch (InterruptedException | ExecutionException e) {
                LOG.error(e.getLocalizedMessage(), (Throwable)e);
            }
            finally {
                uuidNidMapFromEntitiesStopwatch.stop();
                LOG.info("Finished UUID strategy 2 in: " + uuidNidMapFromEntitiesStopwatch.durationString());
                LOG.info(uuidNidCollector.report());
            }
        });
        stopwatch.stop();
        LOG.info("Opened SpinedArrayProvider in: " + stopwatch.durationString());
    }

    private void listAndCancelUncommittedStamps() {
        int[] stampNidArray;
        LOG.info("Searching for canceled stamps in set of size " + this.stampNids.size());
        for (int stampNid : stampNidArray = this.stampNids.stream().sorted().mapToInt(value -> value).toArray()) {
            StampRecord stamp = (StampRecord)Entity.getStamp((int)stampNid);
            LOG.info("Stamp: " + String.valueOf(stamp));
            if (stamp.time() == Long.MAX_VALUE && Transaction.forStamp((PublicId)stamp).isEmpty()) {
                this.cancelUncommittedStamp(stampNid, stamp);
            }
            if (stamp.lastVersion().stateNid() != State.CANCELED.nid()) continue;
            PrimitiveData.get().addCanceledStampNid(stampNid);
        }
    }

    private void cancelUncommittedStamp(int stampNid, StampRecord stamp) {
        LOG.warn("Canceling uncommitted stamp: " + String.valueOf(stamp.publicId().asUuidList()));
        StampVersionRecord lastVersion = stamp.lastVersion();
        StampVersionRecord canceledVersion = lastVersion.with().time(Long.MIN_VALUE).stateNid(State.CANCELED.nid()).build();
        byte[] stampBytes = stamp.without(lastVersion).with(canceledVersion).build().getBytes();
        this.entityToBytesMap.put(stampNid, (Object)stampBytes);
    }

    public long writeSequence() {
        return writeSequence.sum();
    }

    public void close() {
        Stopwatch stopwatch = new Stopwatch();
        LOG.info("Closing SpinedArrayProvider");
        try {
            this.save();
            this.listAndCancelUncommittedStamps();
            this.entityToBytesMap.close();
            singleton = null;
            this.indexer.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            stopwatch.stop();
            LOG.info("Closed SpinedArrayProvider in: " + stopwatch.durationString());
        }
    }

    public void save() {
        Stopwatch stopwatch = new Stopwatch();
        LOG.info("Saving SpinedArrayProvider");
        try {
            Files.writeString(this.nextNidKeyFile.toPath(), (CharSequence)Integer.toString(this.nextNid.get()), new OpenOption[0]);
            this.nidToPatternNidMap.write(this.nidToPatternNidMapDirectory);
            this.entityToBytesMap.write();
            this.nidToCitingComponentsNidMap.write();
            this.indexer.commit();
        }
        catch (IOException e) {
            LOG.error(e.getLocalizedMessage(), (Throwable)e);
        }
        finally {
            stopwatch.stop();
            LOG.info("Save SpinedArrayProvider in: " + stopwatch.durationString());
        }
    }

    public int nidForUuids(UUID ... uuids) {
        try {
            this.uuidsLoadedLatch.await();
            if (uuids.length == 1) {
                return (Integer)this.uuidToNidMap.computeIfAbsent((Object)uuids[0], uuidKey -> this.newNid());
            }
            int nid = Integer.MAX_VALUE;
            for (UUID uuid : uuids) {
                if (nid == Integer.MAX_VALUE) {
                    nid = (Integer)this.uuidToNidMap.computeIfAbsent((Object)uuids[0], uuidKey -> this.newNid());
                    continue;
                }
                this.uuidToNidMap.put((Object)uuid, (Object)nid);
            }
            if (nid == Integer.MIN_VALUE) {
                throw new IllegalStateException("nid cannot be Integer.MIN_VALUE");
            }
            return nid;
        }
        catch (InterruptedException e) {
            LOG.error(e.getLocalizedMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public int newNid() {
        return this.nextNid.getAndIncrement();
    }

    public int nidForUuids(ImmutableList<UUID> uuidList) {
        try {
            this.uuidsLoadedLatch.await();
            if (uuidList.size() == 1) {
                return (Integer)this.uuidToNidMap.computeIfAbsent((Object)((UUID)uuidList.get(0)), uuidKey -> this.newNid());
            }
            int nid = Integer.MAX_VALUE;
            for (UUID uuid : uuidList) {
                if (nid == Integer.MAX_VALUE) {
                    nid = (Integer)this.uuidToNidMap.computeIfAbsent((Object)uuid, uuidKey -> this.newNid());
                    continue;
                }
                this.uuidToNidMap.put((Object)uuid, (Object)nid);
            }
            if (nid == Integer.MIN_VALUE) {
                throw new IllegalStateException("nid cannot be Integer.MIN_VALUE");
            }
            return nid;
        }
        catch (InterruptedException e) {
            LOG.error(e.getLocalizedMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void forEach(ObjIntConsumer<byte[]> action) {
        this.entityToBytesMap.forEach(action);
    }

    public void forEachParallel(ObjIntConsumer<byte[]> action) {
        try {
            this.entityToBytesMap.forEachParallel(action);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public void forEachParallel(ImmutableIntList nids, ObjIntConsumer<byte[]> action) {
        try {
            this.entityToBytesMap.forEachParallel(nids, action);
        }
        catch (InterruptedException | ExecutionException e) {
            AlertStreams.dispatchToRoot((Throwable)e);
        }
    }

    public byte[] getBytes(int nid) {
        return (byte[])this.entityToBytesMap.get(nid);
    }

    public byte[] merge(int nid, int patternNid, int referencedComponentNid, byte[] value, Object sourceObject) {
        if (nid == Integer.MIN_VALUE) {
            LOG.error("NID should not be Integer.MIN_VALUE");
            throw new IllegalStateException("NID should not be Integer.MIN_VALUE");
        }
        if (!this.entityToBytesMap.containsKey(nid)) {
            this.nidToPatternNidMap.put(nid, patternNid);
            if (patternNid != Integer.MAX_VALUE) {
                long citationLong = IntsInLong.ints2Long((int)nid, (int)patternNid);
                this.nidToCitingComponentsNidMap.accumulateAndGet(referencedComponentNid, (Object)new long[]{citationLong}, PrimitiveDataService::mergeCitations);
                this.addToPatternElementSet(patternNid, nid);
            }
            if (sourceObject instanceof ConceptEntity) {
                ConceptEntity concept = (ConceptEntity)sourceObject;
                this.conceptNids.add((Object)concept.nid());
            } else if (sourceObject instanceof SemanticEntity) {
                SemanticEntity semanticEntity = (SemanticEntity)sourceObject;
                this.semanticNids.add((Object)semanticEntity.nid());
            } else if (sourceObject instanceof PatternEntity) {
                PatternEntity patternEntity = (PatternEntity)sourceObject;
                this.patternNids.add((Object)patternEntity.nid());
            } else if (sourceObject instanceof StampEntity) {
                StampEntity stampEntity = (StampEntity)sourceObject;
                this.stampNids.add((Object)stampEntity.nid());
            }
        }
        byte[] mergedBytes = (byte[])this.entityToBytesMap.accumulateAndGet(nid, (Object)value, PrimitiveDataService::merge);
        writeSequence.increment();
        this.indexer.index(sourceObject);
        return mergedBytes;
    }

    public boolean addToPatternElementSet(int patternNid, int elementNid) {
        return ((ConcurrentHashSet)this.patternElementNidsMap.getIfAbsentPut((Object)patternNid, (Function & Serializable)integer -> new ConcurrentHashSet())).add((Object)elementNid);
    }

    public PrimitiveDataSearchResult[] search(String query, int maxResultSize) throws Exception {
        return this.searcher.search(query, maxResultSize);
    }

    public int[] semanticNidsOfPattern(int patternNid) {
        IntSet elementNids = this.getElementNidsForPatternNid(patternNid);
        if (elementNids.notEmpty()) {
            MutableIntList elementNidList = IntLists.mutable.withInitialCapacity(elementNids.size());
            elementNids.forEach((IntProcedure & Serializable)integer -> elementNidList.add(integer));
            return elementNidList.toArray();
        }
        return new int[0];
    }

    public IntSet getElementNidsForPatternNid(int patternNid) {
        if (this.patternElementNidsMap.containsKey((Object)patternNid)) {
            return IntSets.immutable.ofAll(((ConcurrentHashSet)this.patternElementNidsMap.get((Object)patternNid)).stream().mapToInt(value -> value));
        }
        return IntSets.immutable.empty();
    }

    public void forEachSemanticNidOfPattern(int patternNid, IntProcedure procedure) {
        IntSet elementNids;
        if (LOG.isTraceEnabled()) {
            Stopwatch sw = new Stopwatch();
            elementNids = this.getElementNidsForPatternNid(patternNid);
            LOG.atTrace().log("getElementNidsForPatternNid " + PrimitiveData.text((int)patternNid) + " time: " + sw.durationString());
        } else {
            elementNids = this.getElementNidsForPatternNid(patternNid);
        }
        if (elementNids.notEmpty()) {
            elementNids.forEach(procedure);
        } else {
            Entity entity = Entity.getFast((int)patternNid);
            if (!(entity instanceof PatternEntity)) {
                throw new IllegalStateException("Trying to iterate elements for entity that is not a pattern: " + String.valueOf(entity));
            }
        }
    }

    public void forEachPatternNid(IntProcedure procedure) {
        try {
            this.uuidsLoadedLatch.await();
            this.patternNids.forEach(patternNid -> procedure.accept(patternNid.intValue()));
        }
        catch (InterruptedException e) {
            LOG.error(e.getLocalizedMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void forEachConceptNid(IntProcedure procedure) {
        try {
            this.uuidsLoadedLatch.await();
            this.conceptNids.forEach(conceptNid -> procedure.accept(conceptNid.intValue()));
        }
        catch (InterruptedException e) {
            LOG.error(e.getLocalizedMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void forEachStampNid(IntProcedure procedure) {
        try {
            this.uuidsLoadedLatch.await();
            this.stampNids.forEach(stampNid -> procedure.accept(stampNid.intValue()));
        }
        catch (InterruptedException e) {
            LOG.error(e.getLocalizedMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void forEachSemanticNid(IntProcedure procedure) {
        try {
            this.uuidsLoadedLatch.await();
            this.semanticNids.forEach(semanticNid -> procedure.accept(semanticNid.intValue()));
        }
        catch (InterruptedException e) {
            LOG.error(e.getLocalizedMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void forEachSemanticNidForComponent(int componentNid, IntProcedure procedure) {
        long[] citationLongs = (long[])this.nidToCitingComponentsNidMap.get(componentNid);
        if (citationLongs != null) {
            for (long citationLong : citationLongs) {
                int citingComponentNid = (int)(citationLong >> 32);
                procedure.accept(citingComponentNid);
            }
        }
    }

    public void forEachSemanticNidForComponentOfPattern(int componentNid, int patternNid, IntProcedure procedure) {
        long[] citationLongs = (long[])this.nidToCitingComponentsNidMap.get(componentNid);
        if (citationLongs != null) {
            for (long citationLong : citationLongs) {
                int citingComponentNid = (int)(citationLong >> 32);
                int citingComponentPatternNid = (int)citationLong;
                if (patternNid != citingComponentPatternNid) continue;
                procedure.accept(citingComponentNid);
            }
        }
    }

    public String name() {
        return this.name;
    }

    public void erase(int nid) {
        this.entityToBytesMap.put(nid, null);
        this.nidToPatternNidMap.put(nid, Integer.MAX_VALUE);
        this.nidToCitingComponentsNidMap.put(nid, null);
        this.conceptNids.remove((Object)nid);
        this.semanticNids.remove((Object)nid);
        this.patternNids.remove((Object)nid);
        this.stampNids.remove((Object)nid);
        this.nidToCitingComponentsNidMap.forEach((nidPatternsCitingComponent, referencedComponentNid) -> {
            MutableLongList nidPatternInLongToRemove = LongLists.mutable.withInitialCapacity(2);
            for (long nidPatternInLong : nidPatternsCitingComponent) {
                int nidCitingComponent = IntsInLong.int1FromLong((long)nidPatternInLong);
                if (nidCitingComponent != nid) continue;
                nidPatternInLongToRemove.add(nidPatternInLong);
            }
            if (nidPatternInLongToRemove.notEmpty()) {
                MutableLongSet longSet = LongSets.mutable.of(nidPatternsCitingComponent);
                longSet.removeAll((LongIterable)nidPatternInLongToRemove);
                this.nidToCitingComponentsNidMap.put(referencedComponentNid, (Object)longSet.toArray());
            }
        });
    }

    public void mergeThenErase(int nidToErase, int nidToMergeInto) {
        byte[] mergedBytes = this.merge(PrimitiveData.get().getBytes(nidToMergeInto), PrimitiveData.get().getBytes(nidToErase));
        this.erase(nidToErase);
        this.put(nidToMergeInto, mergedBytes);
        EntityService.get().invalidateCaches(new int[]{nidToErase, nidToMergeInto});
    }

    byte[] merge(byte[] bytesToMergeInto, byte[] bytesToBeErased) {
        if (bytesToBeErased == null) {
            return bytesToMergeInto;
        }
        ByteBuf readBufToMergeInto = ByteBuf.wrapForReading((byte[])bytesToMergeInto);
        int mergeIntoArrayCount = readBufToMergeInto.readInt();
        int mergeIntoChronicleArrayElementByteCount = readBufToMergeInto.readInt();
        byte mergeIntoEntityFormatVersion = readBufToMergeInto.readByte();
        byte mergeIntoEntityTypeToken = readBufToMergeInto.readByte();
        int mergeIntoNid = readBufToMergeInto.readInt();
        ImmutableList<UUID> mergeIntoUuids = this.getUuidsFromBytes(readBufToMergeInto);
        ByteBuf readBufToBeErased = ByteBuf.wrapForReading((byte[])bytesToBeErased);
        int eraseComponentArrayCount = readBufToBeErased.readInt();
        int eraseComponentChronicleArrayElementByteCount = readBufToBeErased.readInt();
        byte eraseComponentEntityFormatVersion = readBufToBeErased.readByte();
        byte eraseComponentEntityTypeToken = readBufToBeErased.readByte();
        int eraseComponentNid = readBufToBeErased.readInt();
        ImmutableList<UUID> uuidsFromBytesToBeErased = this.getUuidsFromBytes(readBufToBeErased);
        MutableSet uuidSet = Sets.mutable.ofAll(mergeIntoUuids);
        uuidSet.addAll((Collection)uuidsFromBytesToBeErased.castToList());
        ImmutableList mergedUuids = uuidSet.toImmutableList();
        ByteBuf outputBytesToMergeInto = ByteBufPool.allocate((int)(bytesToMergeInto.length + mergedUuids.size() * 16));
        int additionalMergedBytes = (mergedUuids.size() - mergeIntoUuids.size()) * 16;
        outputBytesToMergeInto.writeInt(mergeIntoArrayCount);
        outputBytesToMergeInto.writeInt(mergeIntoChronicleArrayElementByteCount + additionalMergedBytes);
        outputBytesToMergeInto.writeByte(mergeIntoEntityFormatVersion);
        outputBytesToMergeInto.writeByte(mergeIntoEntityTypeToken);
        outputBytesToMergeInto.writeInt(mergeIntoNid);
        this.writeUuidsAndRemaining((ImmutableList<UUID>)mergedUuids, outputBytesToMergeInto, readBufToMergeInto);
        ByteBuf outputBytesToBeErased = ByteBufPool.allocate((int)(bytesToBeErased.length + mergedUuids.size() * 16));
        int additionalErasedBytes = (mergedUuids.size() - uuidsFromBytesToBeErased.size()) * 16;
        outputBytesToBeErased.writeInt(eraseComponentArrayCount);
        outputBytesToBeErased.writeInt(eraseComponentChronicleArrayElementByteCount + additionalErasedBytes);
        outputBytesToBeErased.writeByte(eraseComponentEntityFormatVersion);
        outputBytesToBeErased.writeByte(eraseComponentEntityTypeToken);
        outputBytesToBeErased.writeInt(mergeIntoNid);
        this.writeUuidsAndRemaining((ImmutableList<UUID>)mergedUuids, outputBytesToBeErased, readBufToBeErased);
        return PrimitiveDataService.merge((byte[])outputBytesToMergeInto.asArray(), (byte[])outputBytesToBeErased.asArray());
    }

    void writeUuidsAndRemaining(ImmutableList<UUID> mergedUuids, ByteBuf outputBytes, ByteBuf readBuf) {
        long[] additionalUuidLongs = UuidUtil.asArray(mergedUuids);
        outputBytes.writeLong(additionalUuidLongs[0]);
        outputBytes.writeLong(additionalUuidLongs[1]);
        outputBytes.writeByte((byte)(additionalUuidLongs.length - 2));
        for (int i = 2; i < additionalUuidLongs.length; ++i) {
            outputBytes.writeLong(additionalUuidLongs[i]);
        }
        int readBufToMergeIntoRemaining = readBuf.readRemaining();
        for (int i = 0; i < readBufToMergeIntoRemaining; ++i) {
            outputBytes.writeByte(readBuf.get());
        }
    }

    ImmutableList<UUID> getUuidsFromBytes(ByteBuf readBuf) {
        MutableList uuids = Lists.mutable.withInitialCapacity(2);
        long msb = readBuf.readLong();
        long lsb = readBuf.readLong();
        uuids.add((Object)new UUID(msb, lsb));
        int additionalUuidLongSize = readBuf.readByte();
        if (additionalUuidLongSize > 0) {
            long[] additionalUuidLongs = new long[additionalUuidLongSize];
            for (int i = 0; i < additionalUuidLongSize; ++i) {
                additionalUuidLongs[i] = readBuf.readLong();
            }
            ImmutableList additionalUuids = UuidUtil.toList((long[])additionalUuidLongs);
            uuids.addAll((Collection)additionalUuids.castToList());
        }
        return uuids.toImmutableList();
    }

    public void put(int nid, byte[] bytesToOverwrite) {
        this.entityToBytesMap.put(nid, (Object)bytesToOverwrite);
    }

    static {
        writeSequence = new LongAdder();
    }
}

