/*
 * Decompiled with CFR 0.152.
 */
package dev.ikm.tinkar.provider.spinedarray;

import dev.ikm.tinkar.common.sets.ConcurrentHashSet;
import dev.ikm.tinkar.common.util.time.Stopwatch;
import dev.ikm.tinkar.component.FieldDataType;
import dev.ikm.tinkar.entity.EntityRecordFactory;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.ObjIntConsumer;
import org.eclipse.collections.impl.map.mutable.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UuidNidCollector
implements ObjIntConsumer<byte[]> {
    private static final Logger LOG = LoggerFactory.getLogger(UuidNidCollector.class);
    final ConcurrentHashMap<UUID, Integer> uuidToNidMap;
    final ConcurrentHashSet<Integer> patternNids;
    final ConcurrentHashSet<Integer> conceptNids;
    final ConcurrentHashSet<Integer> semanticNids;
    final ConcurrentHashSet<Integer> stampNids;
    final ConcurrentHashMap<Integer, ConcurrentHashSet<Integer>> patternElementNidsMap;
    AtomicInteger totalCount = new AtomicInteger();
    AtomicInteger conceptCount = new AtomicInteger();
    AtomicInteger semanticCount = new AtomicInteger();
    AtomicInteger patternCount = new AtomicInteger();
    AtomicInteger stampCount = new AtomicInteger();
    AtomicInteger other = new AtomicInteger();
    Stopwatch stopwatch = new Stopwatch();

    public UuidNidCollector(ConcurrentHashMap<UUID, Integer> uuidToNidMap, ConcurrentHashSet<Integer> patternNids, ConcurrentHashSet<Integer> conceptNids, ConcurrentHashSet<Integer> semanticNids, ConcurrentHashSet<Integer> stampNids, ConcurrentHashMap<Integer, ConcurrentHashSet<Integer>> patternElementNidsMap) {
        this.uuidToNidMap = uuidToNidMap;
        this.patternNids = patternNids;
        this.conceptNids = conceptNids;
        this.semanticNids = semanticNids;
        this.stampNids = stampNids;
        this.patternElementNidsMap = patternElementNidsMap;
    }

    @Override
    public void accept(byte[] bytes, int nid) {
        FieldDataType componentType = FieldDataType.fromToken((byte)bytes[9]);
        if (nid == Integer.MIN_VALUE) {
            LOG.error("value of Integer.MIN_VALUE should not happen. ");
        }
        boolean typeToProcess = false;
        switch (componentType) {
            case PATTERN_CHRONOLOGY: {
                this.patternCount.incrementAndGet();
                this.totalCount.incrementAndGet();
                typeToProcess = true;
                this.patternNids.add((Object)nid);
                break;
            }
            case CONCEPT_CHRONOLOGY: {
                this.conceptCount.incrementAndGet();
                this.totalCount.incrementAndGet();
                this.conceptNids.add((Object)nid);
                typeToProcess = true;
                break;
            }
            case SEMANTIC_CHRONOLOGY: {
                this.semanticCount.incrementAndGet();
                this.totalCount.incrementAndGet();
                typeToProcess = true;
                this.semanticNids.add((Object)nid);
                break;
            }
            case STAMP: {
                this.stampCount.incrementAndGet();
                this.totalCount.incrementAndGet();
                typeToProcess = true;
                this.stampNids.add((Object)nid);
                break;
            }
            default: {
                this.other.incrementAndGet();
                this.totalCount.incrementAndGet();
            }
        }
        if (typeToProcess) {
            EntityRecordFactory.collectUuids((byte[])bytes, this.patternElementNidsMap, this.uuidToNidMap);
        }
    }

    public void finish() {
        this.stopwatch.end();
    }

    public String report() {
        this.stopwatch.end();
        StringBuilder sb = new StringBuilder();
        sb.append("Finished: ").append(this.getClass().getSimpleName());
        sb.append("\nDuration: ").append(this.stopwatch.durationString());
        sb.append("\nAverage realization time: ").append(this.stopwatch.averageDurationForElementString(this.totalCount.get()));
        sb.append("\nUUIDs: ").append(this.uuidToNidMap.size());
        if (this.conceptCount.get() > 0) {
            sb.append("\nConcepts: ").append(this.conceptCount);
        }
        if (this.semanticCount.get() > 0) {
            sb.append("\nSemantics: ").append(this.semanticCount);
        }
        if (this.patternCount.get() > 0) {
            sb.append("\nType pattern: ").append(this.patternCount);
        }
        if (this.stampCount.get() > 0) {
            sb.append("\nStamps: ").append(this.stampCount);
        }
        if (this.other.get() > 0) {
            sb.append("\nOthers: ").append(this.other);
        }
        sb.append("\n");
        return sb.toString();
    }
}

