/*
 * Decompiled with CFR 0.152.
 */
package dev.ikm.tinkar.dto;

import dev.ikm.tinkar.common.id.PublicId;
import dev.ikm.tinkar.dto.ComponentDTO;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Stream;

public class ComponentDTOBuilder {
    private PublicId publicId;

    private ComponentDTOBuilder() {
    }

    private ComponentDTOBuilder(PublicId publicId) {
        this.publicId = publicId;
    }

    public static ComponentDTO ComponentDTO(PublicId publicId) {
        return new ComponentDTO(publicId);
    }

    public static ComponentDTOBuilder builder() {
        return new ComponentDTOBuilder();
    }

    public static ComponentDTOBuilder builder(ComponentDTO from) {
        return new ComponentDTOBuilder(from.publicId());
    }

    public static With from(ComponentDTO from) {
        return new _FromWith(from);
    }

    public static Stream<Map.Entry<String, Object>> stream(ComponentDTO record) {
        return Stream.of(new AbstractMap.SimpleImmutableEntry<String, PublicId>("publicId", record.publicId()));
    }

    public ComponentDTO build() {
        return new ComponentDTO(this.publicId);
    }

    public String toString() {
        return "ComponentDTOBuilder[publicId=" + String.valueOf(this.publicId) + "]";
    }

    public int hashCode() {
        return Objects.hash(this.publicId);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof ComponentDTOBuilder)) return false;
        ComponentDTOBuilder r = (ComponentDTOBuilder)o;
        if (!Objects.equals(this.publicId, r.publicId)) return false;
        return true;
    }

    public ComponentDTOBuilder publicId(PublicId publicId) {
        this.publicId = publicId;
        return this;
    }

    public PublicId publicId() {
        return this.publicId;
    }

    private static final class _FromWith
    implements With {
        private final ComponentDTO from;

        private _FromWith(ComponentDTO from) {
            this.from = from;
        }

        @Override
        public PublicId publicId() {
            return this.from.publicId();
        }
    }

    public static interface With {
        public PublicId publicId();

        default public ComponentDTOBuilder with() {
            return new ComponentDTOBuilder(this.publicId());
        }

        default public ComponentDTO with(Consumer<ComponentDTOBuilder> consumer) {
            ComponentDTOBuilder builder = this.with();
            consumer.accept(builder);
            return builder.build();
        }

        default public ComponentDTO withPublicId(PublicId publicId) {
            return new ComponentDTO(publicId);
        }
    }
}

