/*
 * Decompiled with CFR 0.152.
 */
package dev.ikm.tinkar.dto;

import dev.ikm.tinkar.common.id.PublicId;
import dev.ikm.tinkar.component.ConceptChronology;
import dev.ikm.tinkar.component.ConceptVersion;
import dev.ikm.tinkar.dto.ConceptVersionDTO;
import dev.ikm.tinkar.dto.DTO;
import dev.ikm.tinkar.dto.binary.Marshalable;
import dev.ikm.tinkar.dto.binary.Marshaler;
import dev.ikm.tinkar.dto.binary.TinkarInput;
import dev.ikm.tinkar.dto.binary.TinkarOutput;
import dev.ikm.tinkar.dto.binary.Unmarshaler;
import org.eclipse.collections.api.factory.Lists;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.api.list.MutableList;

public record ConceptChronologyDTO(PublicId publicId, ImmutableList<ConceptVersionDTO> versions) implements Marshalable,
ConceptChronology<ConceptVersionDTO>,
DTO
{
    private static final int localMarshalVersion = 3;

    public static ConceptChronologyDTO make(ConceptChronology<? extends ConceptVersion> conceptChronology) {
        MutableList versions = Lists.mutable.ofInitialCapacity(conceptChronology.versions().size());
        for (ConceptVersion conceptVersion : conceptChronology.versions()) {
            versions.add((Object)ConceptVersionDTO.make(conceptVersion));
        }
        return new ConceptChronologyDTO(conceptChronology.publicId(), (ImmutableList<ConceptVersionDTO>)versions.toImmutable());
    }

    @Unmarshaler
    public static ConceptChronologyDTO make(TinkarInput in) {
        if (3 == in.getTinkerFormatVersion()) {
            PublicId publicId = in.getPublicId();
            return new ConceptChronologyDTO(publicId, in.readConceptVersionList(publicId));
        }
        throw new UnsupportedOperationException("Unsupported version: " + in.getTinkerFormatVersion());
    }

    @Override
    @Marshaler
    public void marshal(TinkarOutput out) {
        out.putPublicId(this.publicId);
        out.writeConceptVersionList(this.versions);
    }
}

