/*
 * Decompiled with CFR 0.152.
 */
package dev.ikm.tinkar.dto;

import dev.ikm.tinkar.common.id.PublicId;
import dev.ikm.tinkar.dto.ConceptChronologyDTO;
import dev.ikm.tinkar.dto.ConceptVersionDTO;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.eclipse.collections.api.list.ImmutableList;

public class ConceptChronologyDTOBuilder {
    private PublicId publicId;
    private ImmutableList<ConceptVersionDTO> versions;

    private ConceptChronologyDTOBuilder() {
    }

    private ConceptChronologyDTOBuilder(PublicId publicId, ImmutableList<ConceptVersionDTO> versions) {
        this.publicId = publicId;
        this.versions = versions;
    }

    public static ConceptChronologyDTO ConceptChronologyDTO(PublicId publicId, ImmutableList<ConceptVersionDTO> versions) {
        return new ConceptChronologyDTO(publicId, versions);
    }

    public static ConceptChronologyDTOBuilder builder() {
        return new ConceptChronologyDTOBuilder();
    }

    public static ConceptChronologyDTOBuilder builder(ConceptChronologyDTO from) {
        return new ConceptChronologyDTOBuilder(from.publicId(), from.versions());
    }

    public static With from(ConceptChronologyDTO from) {
        return new _FromWith(from);
    }

    public static Stream<Map.Entry<String, Object>> stream(ConceptChronologyDTO record) {
        return Stream.of(new AbstractMap.SimpleImmutableEntry<String, PublicId>("publicId", record.publicId()), new AbstractMap.SimpleImmutableEntry<String, ImmutableList<ConceptVersionDTO>>("versions", record.versions()));
    }

    public ConceptChronologyDTO build() {
        return new ConceptChronologyDTO(this.publicId, this.versions);
    }

    public String toString() {
        return "ConceptChronologyDTOBuilder[publicId=" + String.valueOf(this.publicId) + ", versions=" + String.valueOf(this.versions) + "]";
    }

    public int hashCode() {
        return Objects.hash(this.publicId, this.versions);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof ConceptChronologyDTOBuilder)) return false;
        ConceptChronologyDTOBuilder r = (ConceptChronologyDTOBuilder)o;
        if (!Objects.equals(this.publicId, r.publicId)) return false;
        if (!Objects.equals(this.versions, r.versions)) return false;
        return true;
    }

    public ConceptChronologyDTOBuilder publicId(PublicId publicId) {
        this.publicId = publicId;
        return this;
    }

    public PublicId publicId() {
        return this.publicId;
    }

    public ConceptChronologyDTOBuilder versions(ImmutableList<ConceptVersionDTO> versions) {
        this.versions = versions;
        return this;
    }

    public ImmutableList<ConceptVersionDTO> versions() {
        return this.versions;
    }

    private static final class _FromWith
    implements With {
        private final ConceptChronologyDTO from;

        private _FromWith(ConceptChronologyDTO from) {
            this.from = from;
        }

        @Override
        public PublicId publicId() {
            return this.from.publicId();
        }

        @Override
        public ImmutableList<ConceptVersionDTO> versions() {
            return this.from.versions();
        }
    }

    public static interface With {
        public PublicId publicId();

        public ImmutableList<ConceptVersionDTO> versions();

        default public ConceptChronologyDTOBuilder with() {
            return new ConceptChronologyDTOBuilder(this.publicId(), this.versions());
        }

        default public ConceptChronologyDTO with(Consumer<ConceptChronologyDTOBuilder> consumer) {
            ConceptChronologyDTOBuilder builder = this.with();
            consumer.accept(builder);
            return builder.build();
        }

        default public ConceptChronologyDTO withPublicId(PublicId publicId) {
            return new ConceptChronologyDTO(publicId, this.versions());
        }

        default public ConceptChronologyDTO withVersions(ImmutableList<ConceptVersionDTO> versions) {
            return new ConceptChronologyDTO(this.publicId(), versions);
        }
    }
}

