/*
 * Decompiled with CFR 0.152.
 */
package dev.ikm.tinkar.dto;

import dev.ikm.tinkar.common.id.PublicId;
import dev.ikm.tinkar.common.id.PublicIds;
import dev.ikm.tinkar.component.Concept;
import dev.ikm.tinkar.dto.DTO;
import dev.ikm.tinkar.dto.binary.Marshalable;
import dev.ikm.tinkar.dto.binary.Marshaler;
import dev.ikm.tinkar.dto.binary.TinkarInput;
import dev.ikm.tinkar.dto.binary.TinkarOutput;
import dev.ikm.tinkar.dto.binary.Unmarshaler;
import java.util.List;
import java.util.UUID;
import org.eclipse.collections.api.factory.Lists;
import org.eclipse.collections.api.list.MutableList;

public record ConceptDTO(PublicId publicId) implements Concept,
DTO,
Marshalable
{
    private static final int localMarshalVersion = 3;

    @Unmarshaler
    public static ConceptDTO make(TinkarInput in) {
        if (3 == in.getTinkerFormatVersion()) {
            PublicId componentPublicId = in.getPublicId();
            return new ConceptDTO(componentPublicId);
        }
        throw new UnsupportedOperationException("Unsupported version: 3");
    }

    public static ConceptDTO make(String uuidListString) {
        uuidListString = uuidListString.replace("[", "");
        uuidListString = uuidListString.replace("]", "");
        uuidListString = uuidListString.replace(",", "");
        uuidListString = uuidListString.replace("\"", "");
        String[] uuidStrings = uuidListString.split(" ");
        MutableList componentUuids = Lists.mutable.ofInitialCapacity(uuidStrings.length);
        for (String uuidString : uuidStrings) {
            componentUuids.add((Object)UUID.fromString(uuidString));
        }
        return new ConceptDTO(PublicIds.of((List)componentUuids));
    }

    @Override
    @Marshaler
    public void marshal(TinkarOutput out) {
        out.putPublicId(this.publicId());
    }
}

