/*
 * Decompiled with CFR 0.152.
 */
package dev.ikm.tinkar.dto;

import dev.ikm.tinkar.common.id.PublicId;
import dev.ikm.tinkar.dto.ConceptDTO;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Stream;

public class ConceptDTOBuilder {
    private PublicId publicId;

    private ConceptDTOBuilder() {
    }

    private ConceptDTOBuilder(PublicId publicId) {
        this.publicId = publicId;
    }

    public static ConceptDTO ConceptDTO(PublicId publicId) {
        return new ConceptDTO(publicId);
    }

    public static ConceptDTOBuilder builder() {
        return new ConceptDTOBuilder();
    }

    public static ConceptDTOBuilder builder(ConceptDTO from) {
        return new ConceptDTOBuilder(from.publicId());
    }

    public static With from(ConceptDTO from) {
        return new _FromWith(from);
    }

    public static Stream<Map.Entry<String, Object>> stream(ConceptDTO record) {
        return Stream.of(new AbstractMap.SimpleImmutableEntry<String, PublicId>("publicId", record.publicId()));
    }

    public ConceptDTO build() {
        return new ConceptDTO(this.publicId);
    }

    public String toString() {
        return "ConceptDTOBuilder[publicId=" + String.valueOf(this.publicId) + "]";
    }

    public int hashCode() {
        return Objects.hash(this.publicId);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof ConceptDTOBuilder)) return false;
        ConceptDTOBuilder r = (ConceptDTOBuilder)o;
        if (!Objects.equals(this.publicId, r.publicId)) return false;
        return true;
    }

    public ConceptDTOBuilder publicId(PublicId publicId) {
        this.publicId = publicId;
        return this;
    }

    public PublicId publicId() {
        return this.publicId;
    }

    private static final class _FromWith
    implements With {
        private final ConceptDTO from;

        private _FromWith(ConceptDTO from) {
            this.from = from;
        }

        @Override
        public PublicId publicId() {
            return this.from.publicId();
        }
    }

    public static interface With {
        public PublicId publicId();

        default public ConceptDTOBuilder with() {
            return new ConceptDTOBuilder(this.publicId());
        }

        default public ConceptDTO with(Consumer<ConceptDTOBuilder> consumer) {
            ConceptDTOBuilder builder = this.with();
            consumer.accept(builder);
            return builder.build();
        }

        default public ConceptDTO withPublicId(PublicId publicId) {
            return new ConceptDTO(publicId);
        }
    }
}

