/*
 * Decompiled with CFR 0.152.
 */
package dev.ikm.tinkar.dto;

import dev.ikm.tinkar.common.id.PublicId;
import dev.ikm.tinkar.component.ConceptVersion;
import dev.ikm.tinkar.dto.DTO;
import dev.ikm.tinkar.dto.StampDTO;
import dev.ikm.tinkar.dto.binary.Marshalable;
import dev.ikm.tinkar.dto.binary.Marshaler;
import dev.ikm.tinkar.dto.binary.TinkarInput;
import dev.ikm.tinkar.dto.binary.TinkarOutput;
import dev.ikm.tinkar.dto.binary.VersionUnmarshaler;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;

public final class ConceptVersionDTO
extends Record
implements ConceptVersion,
DTO,
Marshalable {
    private final PublicId publicId;
    private final StampDTO stamp;
    private static final int localMarshalVersion = 3;

    public ConceptVersionDTO(PublicId publicId, StampDTO stamp) {
        this.publicId = publicId;
        this.stamp = stamp;
    }

    public static ConceptVersionDTO make(ConceptVersion conceptVersion) {
        return new ConceptVersionDTO(conceptVersion.publicId(), StampDTO.make(conceptVersion.stamp()));
    }

    @VersionUnmarshaler
    public static ConceptVersionDTO make(TinkarInput in, PublicId publicId) {
        if (3 == in.getTinkerFormatVersion()) {
            return new ConceptVersionDTO(publicId, StampDTO.make(in));
        }
        throw new UnsupportedOperationException("Unsupported version: " + in.getTinkerFormatVersion());
    }

    @Override
    @Marshaler
    public void marshal(TinkarOutput out) {
        this.stamp.marshal(out);
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{ConceptVersionDTO.class, "publicId;stamp", "publicId", "stamp"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ConceptVersionDTO.class, "publicId;stamp", "publicId", "stamp"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ConceptVersionDTO.class, "publicId;stamp", "publicId", "stamp"}, this, o);
    }

    public PublicId publicId() {
        return this.publicId;
    }

    public StampDTO stamp() {
        return this.stamp;
    }
}

