/*
 * Decompiled with CFR 0.152.
 */
package dev.ikm.tinkar.dto;

import dev.ikm.tinkar.common.id.PublicId;
import dev.ikm.tinkar.dto.ConceptVersionDTO;
import dev.ikm.tinkar.dto.StampDTO;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Stream;

public class ConceptVersionDTOBuilder {
    private PublicId publicId;
    private StampDTO stamp;

    private ConceptVersionDTOBuilder() {
    }

    private ConceptVersionDTOBuilder(PublicId publicId, StampDTO stamp) {
        this.publicId = publicId;
        this.stamp = stamp;
    }

    public static ConceptVersionDTO ConceptVersionDTO(PublicId publicId, StampDTO stamp) {
        return new ConceptVersionDTO(publicId, stamp);
    }

    public static ConceptVersionDTOBuilder builder() {
        return new ConceptVersionDTOBuilder();
    }

    public static ConceptVersionDTOBuilder builder(ConceptVersionDTO from) {
        return new ConceptVersionDTOBuilder(from.publicId(), from.stamp());
    }

    public static With from(ConceptVersionDTO from) {
        return new _FromWith(from);
    }

    public static Stream<Map.Entry<String, Object>> stream(ConceptVersionDTO record) {
        return Stream.of(new AbstractMap.SimpleImmutableEntry<String, PublicId>("publicId", record.publicId()), new AbstractMap.SimpleImmutableEntry<String, StampDTO>("stamp", record.stamp()));
    }

    public ConceptVersionDTO build() {
        return new ConceptVersionDTO(this.publicId, this.stamp);
    }

    public String toString() {
        return "ConceptVersionDTOBuilder[publicId=" + String.valueOf(this.publicId) + ", stamp=" + String.valueOf(this.stamp) + "]";
    }

    public int hashCode() {
        return Objects.hash(this.publicId, this.stamp);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof ConceptVersionDTOBuilder)) return false;
        ConceptVersionDTOBuilder r = (ConceptVersionDTOBuilder)o;
        if (!Objects.equals(this.publicId, r.publicId)) return false;
        if (!Objects.equals(this.stamp, r.stamp)) return false;
        return true;
    }

    public ConceptVersionDTOBuilder publicId(PublicId publicId) {
        this.publicId = publicId;
        return this;
    }

    public PublicId publicId() {
        return this.publicId;
    }

    public ConceptVersionDTOBuilder stamp(StampDTO stamp) {
        this.stamp = stamp;
        return this;
    }

    public StampDTO stamp() {
        return this.stamp;
    }

    private static final class _FromWith
    implements With {
        private final ConceptVersionDTO from;

        private _FromWith(ConceptVersionDTO from) {
            this.from = from;
        }

        @Override
        public PublicId publicId() {
            return this.from.publicId();
        }

        @Override
        public StampDTO stamp() {
            return this.from.stamp();
        }
    }

    public static interface With {
        public PublicId publicId();

        public StampDTO stamp();

        default public ConceptVersionDTOBuilder with() {
            return new ConceptVersionDTOBuilder(this.publicId(), this.stamp());
        }

        default public ConceptVersionDTO with(Consumer<ConceptVersionDTOBuilder> consumer) {
            ConceptVersionDTOBuilder builder = this.with();
            consumer.accept(builder);
            return builder.build();
        }

        default public ConceptVersionDTO withPublicId(PublicId publicId) {
            return new ConceptVersionDTO(publicId, this.stamp());
        }

        default public ConceptVersionDTO withStamp(StampDTO stamp) {
            return new ConceptVersionDTO(this.publicId(), stamp);
        }
    }
}

