/*
 * Decompiled with CFR 0.152.
 */
package dev.ikm.tinkar.dto;

import dev.ikm.tinkar.common.id.PublicId;
import dev.ikm.tinkar.component.Concept;
import dev.ikm.tinkar.component.FieldDefinition;
import dev.ikm.tinkar.dto.ConceptDTO;
import dev.ikm.tinkar.dto.binary.Marshalable;
import dev.ikm.tinkar.dto.binary.Marshaler;
import dev.ikm.tinkar.dto.binary.TinkarInput;
import dev.ikm.tinkar.dto.binary.TinkarOutput;
import dev.ikm.tinkar.dto.binary.Unmarshaler;

public record FieldDefinitionDTO(PublicId dataTypePublicId, PublicId purposePublicId, PublicId meaningPublicId) implements FieldDefinition,
Marshalable
{
    private static final int localMarshalVersion = 3;

    public static FieldDefinitionDTO make(FieldDefinition fieldDefinition) {
        return new FieldDefinitionDTO(fieldDefinition.dataType().publicId(), fieldDefinition.purpose().publicId(), fieldDefinition.meaning().publicId());
    }

    @Unmarshaler
    public static FieldDefinitionDTO make(TinkarInput in) {
        if (3 == in.getTinkerFormatVersion()) {
            return new FieldDefinitionDTO(in.getPublicId(), in.getPublicId(), in.getPublicId());
        }
        throw new UnsupportedOperationException("Unsupported version: " + in.getTinkerFormatVersion());
    }

    public Concept dataType() {
        return new ConceptDTO(this.dataTypePublicId);
    }

    public Concept purpose() {
        return new ConceptDTO(this.purposePublicId);
    }

    public Concept meaning() {
        return new ConceptDTO(this.meaningPublicId);
    }

    @Override
    @Marshaler
    public void marshal(TinkarOutput out) {
        out.putPublicId(this.dataTypePublicId);
        out.putPublicId(this.purposePublicId);
        out.putPublicId(this.meaningPublicId);
    }
}

