/*
 * Decompiled with CFR 0.152.
 */
package dev.ikm.tinkar.dto;

import dev.ikm.tinkar.common.id.PublicId;
import dev.ikm.tinkar.dto.FieldDefinitionDTO;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Stream;

public class FieldDefinitionDTOBuilder {
    private PublicId dataTypePublicId;
    private PublicId purposePublicId;
    private PublicId meaningPublicId;

    private FieldDefinitionDTOBuilder() {
    }

    private FieldDefinitionDTOBuilder(PublicId dataTypePublicId, PublicId purposePublicId, PublicId meaningPublicId) {
        this.dataTypePublicId = dataTypePublicId;
        this.purposePublicId = purposePublicId;
        this.meaningPublicId = meaningPublicId;
    }

    public static FieldDefinitionDTO FieldDefinitionDTO(PublicId dataTypePublicId, PublicId purposePublicId, PublicId meaningPublicId) {
        return new FieldDefinitionDTO(dataTypePublicId, purposePublicId, meaningPublicId);
    }

    public static FieldDefinitionDTOBuilder builder() {
        return new FieldDefinitionDTOBuilder();
    }

    public static FieldDefinitionDTOBuilder builder(FieldDefinitionDTO from) {
        return new FieldDefinitionDTOBuilder(from.dataTypePublicId(), from.purposePublicId(), from.meaningPublicId());
    }

    public static With from(FieldDefinitionDTO from) {
        return new _FromWith(from);
    }

    public static Stream<Map.Entry<String, Object>> stream(FieldDefinitionDTO record) {
        return Stream.of(new AbstractMap.SimpleImmutableEntry<String, PublicId>("dataTypePublicId", record.dataTypePublicId()), new AbstractMap.SimpleImmutableEntry<String, PublicId>("purposePublicId", record.purposePublicId()), new AbstractMap.SimpleImmutableEntry<String, PublicId>("meaningPublicId", record.meaningPublicId()));
    }

    public FieldDefinitionDTO build() {
        return new FieldDefinitionDTO(this.dataTypePublicId, this.purposePublicId, this.meaningPublicId);
    }

    public String toString() {
        return "FieldDefinitionDTOBuilder[dataTypePublicId=" + String.valueOf(this.dataTypePublicId) + ", purposePublicId=" + String.valueOf(this.purposePublicId) + ", meaningPublicId=" + String.valueOf(this.meaningPublicId) + "]";
    }

    public int hashCode() {
        return Objects.hash(this.dataTypePublicId, this.purposePublicId, this.meaningPublicId);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof FieldDefinitionDTOBuilder)) return false;
        FieldDefinitionDTOBuilder r = (FieldDefinitionDTOBuilder)o;
        if (!Objects.equals(this.dataTypePublicId, r.dataTypePublicId)) return false;
        if (!Objects.equals(this.purposePublicId, r.purposePublicId)) return false;
        if (!Objects.equals(this.meaningPublicId, r.meaningPublicId)) return false;
        return true;
    }

    public FieldDefinitionDTOBuilder dataTypePublicId(PublicId dataTypePublicId) {
        this.dataTypePublicId = dataTypePublicId;
        return this;
    }

    public PublicId dataTypePublicId() {
        return this.dataTypePublicId;
    }

    public FieldDefinitionDTOBuilder purposePublicId(PublicId purposePublicId) {
        this.purposePublicId = purposePublicId;
        return this;
    }

    public PublicId purposePublicId() {
        return this.purposePublicId;
    }

    public FieldDefinitionDTOBuilder meaningPublicId(PublicId meaningPublicId) {
        this.meaningPublicId = meaningPublicId;
        return this;
    }

    public PublicId meaningPublicId() {
        return this.meaningPublicId;
    }

    private static final class _FromWith
    implements With {
        private final FieldDefinitionDTO from;

        private _FromWith(FieldDefinitionDTO from) {
            this.from = from;
        }

        @Override
        public PublicId dataTypePublicId() {
            return this.from.dataTypePublicId();
        }

        @Override
        public PublicId purposePublicId() {
            return this.from.purposePublicId();
        }

        @Override
        public PublicId meaningPublicId() {
            return this.from.meaningPublicId();
        }
    }

    public static interface With {
        public PublicId dataTypePublicId();

        public PublicId purposePublicId();

        public PublicId meaningPublicId();

        default public FieldDefinitionDTOBuilder with() {
            return new FieldDefinitionDTOBuilder(this.dataTypePublicId(), this.purposePublicId(), this.meaningPublicId());
        }

        default public FieldDefinitionDTO with(Consumer<FieldDefinitionDTOBuilder> consumer) {
            FieldDefinitionDTOBuilder builder = this.with();
            consumer.accept(builder);
            return builder.build();
        }

        default public FieldDefinitionDTO withDataTypePublicId(PublicId dataTypePublicId) {
            return new FieldDefinitionDTO(dataTypePublicId, this.purposePublicId(), this.meaningPublicId());
        }

        default public FieldDefinitionDTO withPurposePublicId(PublicId purposePublicId) {
            return new FieldDefinitionDTO(this.dataTypePublicId(), purposePublicId, this.meaningPublicId());
        }

        default public FieldDefinitionDTO withMeaningPublicId(PublicId meaningPublicId) {
            return new FieldDefinitionDTO(this.dataTypePublicId(), this.purposePublicId(), meaningPublicId);
        }
    }
}

