/*
 * Decompiled with CFR 0.152.
 */
package dev.ikm.tinkar.dto;

import dev.ikm.tinkar.common.id.PublicId;
import dev.ikm.tinkar.component.PatternChronology;
import dev.ikm.tinkar.component.PatternVersion;
import dev.ikm.tinkar.dto.DTO;
import dev.ikm.tinkar.dto.PatternVersionDTO;
import dev.ikm.tinkar.dto.binary.Marshalable;
import dev.ikm.tinkar.dto.binary.Marshaler;
import dev.ikm.tinkar.dto.binary.TinkarInput;
import dev.ikm.tinkar.dto.binary.TinkarOutput;
import dev.ikm.tinkar.dto.binary.Unmarshaler;
import java.io.Serializable;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.factory.Lists;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.api.list.MutableList;

public record PatternChronologyDTO(PublicId publicId, ImmutableList<PatternVersionDTO> patternVersions) implements PatternChronology<PatternVersionDTO>,
DTO,
Marshalable
{
    private static final int localMarshalVersion = 3;

    public static PatternChronologyDTO make(PatternChronology<? extends PatternVersion> patternChronology) {
        MutableList versions = Lists.mutable.ofInitialCapacity(patternChronology.versions().size());
        for (PatternVersion patternVersion : patternChronology.versions()) {
            versions.add((Object)PatternVersionDTO.make(patternVersion));
        }
        return new PatternChronologyDTO(patternChronology.publicId(), (ImmutableList<PatternVersionDTO>)versions.toImmutable());
    }

    @Unmarshaler
    public static PatternChronologyDTO make(TinkarInput in) {
        if (3 == in.getTinkerFormatVersion()) {
            PublicId publicId = in.getPublicId();
            return new PatternChronologyDTO(publicId, in.readPatternVersionList(publicId));
        }
        throw new UnsupportedOperationException("Unsupported version: " + in.getTinkerFormatVersion());
    }

    public ImmutableList<PatternVersionDTO> versions() {
        return this.patternVersions.collect((Function & Serializable)patternVersionDTO -> patternVersionDTO);
    }

    @Override
    @Marshaler
    public void marshal(TinkarOutput out) {
        out.putPublicId(this.publicId());
        out.writePatternVersionList(this.patternVersions);
    }
}

