/*
 * Decompiled with CFR 0.152.
 */
package dev.ikm.tinkar.dto;

import dev.ikm.tinkar.common.id.PublicId;
import dev.ikm.tinkar.dto.PatternChronologyDTO;
import dev.ikm.tinkar.dto.PatternVersionDTO;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.eclipse.collections.api.list.ImmutableList;

public class PatternChronologyDTOBuilder {
    private PublicId publicId;
    private ImmutableList<PatternVersionDTO> patternVersions;

    private PatternChronologyDTOBuilder() {
    }

    private PatternChronologyDTOBuilder(PublicId publicId, ImmutableList<PatternVersionDTO> patternVersions) {
        this.publicId = publicId;
        this.patternVersions = patternVersions;
    }

    public static PatternChronologyDTO PatternChronologyDTO(PublicId publicId, ImmutableList<PatternVersionDTO> patternVersions) {
        return new PatternChronologyDTO(publicId, patternVersions);
    }

    public static PatternChronologyDTOBuilder builder() {
        return new PatternChronologyDTOBuilder();
    }

    public static PatternChronologyDTOBuilder builder(PatternChronologyDTO from) {
        return new PatternChronologyDTOBuilder(from.publicId(), from.patternVersions());
    }

    public static With from(PatternChronologyDTO from) {
        return new _FromWith(from);
    }

    public static Stream<Map.Entry<String, Object>> stream(PatternChronologyDTO record) {
        return Stream.of(new AbstractMap.SimpleImmutableEntry<String, PublicId>("publicId", record.publicId()), new AbstractMap.SimpleImmutableEntry<String, ImmutableList<PatternVersionDTO>>("patternVersions", record.patternVersions()));
    }

    public PatternChronologyDTO build() {
        return new PatternChronologyDTO(this.publicId, this.patternVersions);
    }

    public String toString() {
        return "PatternChronologyDTOBuilder[publicId=" + String.valueOf(this.publicId) + ", patternVersions=" + String.valueOf(this.patternVersions) + "]";
    }

    public int hashCode() {
        return Objects.hash(this.publicId, this.patternVersions);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof PatternChronologyDTOBuilder)) return false;
        PatternChronologyDTOBuilder r = (PatternChronologyDTOBuilder)o;
        if (!Objects.equals(this.publicId, r.publicId)) return false;
        if (!Objects.equals(this.patternVersions, r.patternVersions)) return false;
        return true;
    }

    public PatternChronologyDTOBuilder publicId(PublicId publicId) {
        this.publicId = publicId;
        return this;
    }

    public PublicId publicId() {
        return this.publicId;
    }

    public PatternChronologyDTOBuilder patternVersions(ImmutableList<PatternVersionDTO> patternVersions) {
        this.patternVersions = patternVersions;
        return this;
    }

    public ImmutableList<PatternVersionDTO> patternVersions() {
        return this.patternVersions;
    }

    private static final class _FromWith
    implements With {
        private final PatternChronologyDTO from;

        private _FromWith(PatternChronologyDTO from) {
            this.from = from;
        }

        @Override
        public PublicId publicId() {
            return this.from.publicId();
        }

        @Override
        public ImmutableList<PatternVersionDTO> patternVersions() {
            return this.from.patternVersions();
        }
    }

    public static interface With {
        public PublicId publicId();

        public ImmutableList<PatternVersionDTO> patternVersions();

        default public PatternChronologyDTOBuilder with() {
            return new PatternChronologyDTOBuilder(this.publicId(), this.patternVersions());
        }

        default public PatternChronologyDTO with(Consumer<PatternChronologyDTOBuilder> consumer) {
            PatternChronologyDTOBuilder builder = this.with();
            consumer.accept(builder);
            return builder.build();
        }

        default public PatternChronologyDTO withPublicId(PublicId publicId) {
            return new PatternChronologyDTO(publicId, this.patternVersions());
        }

        default public PatternChronologyDTO withPatternVersions(ImmutableList<PatternVersionDTO> patternVersions) {
            return new PatternChronologyDTO(this.publicId(), patternVersions);
        }
    }
}

