/*
 * Decompiled with CFR 0.152.
 */
package dev.ikm.tinkar.dto;

import dev.ikm.tinkar.common.id.PublicId;
import dev.ikm.tinkar.dto.PatternDTO;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Stream;

public class PatternDTOBuilder {
    private PublicId publicId;

    private PatternDTOBuilder() {
    }

    private PatternDTOBuilder(PublicId publicId) {
        this.publicId = publicId;
    }

    public static PatternDTO PatternDTO(PublicId publicId) {
        return new PatternDTO(publicId);
    }

    public static PatternDTOBuilder builder() {
        return new PatternDTOBuilder();
    }

    public static PatternDTOBuilder builder(PatternDTO from) {
        return new PatternDTOBuilder(from.publicId());
    }

    public static With from(PatternDTO from) {
        return new _FromWith(from);
    }

    public static Stream<Map.Entry<String, Object>> stream(PatternDTO record) {
        return Stream.of(new AbstractMap.SimpleImmutableEntry<String, PublicId>("publicId", record.publicId()));
    }

    public PatternDTO build() {
        return new PatternDTO(this.publicId);
    }

    public String toString() {
        return "PatternDTOBuilder[publicId=" + String.valueOf(this.publicId) + "]";
    }

    public int hashCode() {
        return Objects.hash(this.publicId);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof PatternDTOBuilder)) return false;
        PatternDTOBuilder r = (PatternDTOBuilder)o;
        if (!Objects.equals(this.publicId, r.publicId)) return false;
        return true;
    }

    public PatternDTOBuilder publicId(PublicId publicId) {
        this.publicId = publicId;
        return this;
    }

    public PublicId publicId() {
        return this.publicId;
    }

    private static final class _FromWith
    implements With {
        private final PatternDTO from;

        private _FromWith(PatternDTO from) {
            this.from = from;
        }

        @Override
        public PublicId publicId() {
            return this.from.publicId();
        }
    }

    public static interface With {
        public PublicId publicId();

        default public PatternDTOBuilder with() {
            return new PatternDTOBuilder(this.publicId());
        }

        default public PatternDTO with(Consumer<PatternDTOBuilder> consumer) {
            PatternDTOBuilder builder = this.with();
            consumer.accept(builder);
            return builder.build();
        }

        default public PatternDTO withPublicId(PublicId publicId) {
            return new PatternDTO(publicId);
        }
    }
}

