/*
 * Decompiled with CFR 0.152.
 */
package dev.ikm.tinkar.dto;

import dev.ikm.tinkar.common.id.PublicId;
import dev.ikm.tinkar.component.Concept;
import dev.ikm.tinkar.component.FieldDefinition;
import dev.ikm.tinkar.component.PatternVersion;
import dev.ikm.tinkar.dto.ConceptDTO;
import dev.ikm.tinkar.dto.FieldDefinitionDTO;
import dev.ikm.tinkar.dto.StampDTO;
import dev.ikm.tinkar.dto.binary.Marshalable;
import dev.ikm.tinkar.dto.binary.Marshaler;
import dev.ikm.tinkar.dto.binary.TinkarInput;
import dev.ikm.tinkar.dto.binary.TinkarOutput;
import dev.ikm.tinkar.dto.binary.VersionUnmarshaler;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.factory.Lists;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.api.list.MutableList;

public final class PatternVersionDTO
extends Record
implements PatternVersion,
Marshalable {
    private final PublicId publicId;
    private final StampDTO stamp;
    private final PublicId semanticPurposePublicId;
    private final PublicId semanticMeaningPublicId;
    private final ImmutableList<FieldDefinitionDTO> fieldDefinitionDTOS;
    private static final int localMarshalVersion = 3;

    public PatternVersionDTO(PublicId publicId, StampDTO stamp, PublicId semanticPurposePublicId, PublicId semanticMeaningPublicId, ImmutableList<FieldDefinitionDTO> fieldDefinitionDTOS) {
        this.publicId = publicId;
        this.stamp = stamp;
        this.semanticPurposePublicId = semanticPurposePublicId;
        this.semanticMeaningPublicId = semanticMeaningPublicId;
        this.fieldDefinitionDTOS = fieldDefinitionDTOS;
    }

    public static PatternVersionDTO make(PatternVersion patternVersion) {
        MutableList fields = Lists.mutable.ofInitialCapacity(patternVersion.fieldDefinitions().size());
        for (FieldDefinition fieldDefinition : patternVersion.fieldDefinitions()) {
            fields.add((Object)FieldDefinitionDTO.make(fieldDefinition));
        }
        return new PatternVersionDTO(patternVersion.publicId(), StampDTO.make(patternVersion.stamp()), patternVersion.semanticPurpose().publicId(), patternVersion.semanticMeaning().publicId(), (ImmutableList<FieldDefinitionDTO>)fields.toImmutable());
    }

    @VersionUnmarshaler
    public static PatternVersionDTO make(TinkarInput in, PublicId componentPublicId) {
        if (3 == in.getTinkerFormatVersion()) {
            return new PatternVersionDTO(componentPublicId, StampDTO.make(in), in.getPublicId(), in.getPublicId(), in.readFieldDefinitionList());
        }
        throw new UnsupportedOperationException("Unsupported version: " + in.getTinkerFormatVersion());
    }

    public ImmutableList<FieldDefinitionDTO> fieldDefinitions() {
        return this.fieldDefinitionDTOS.collect((Function & Serializable)fieldDefinitionDTO -> fieldDefinitionDTO);
    }

    public Concept semanticPurpose() {
        return new ConceptDTO(this.semanticPurposePublicId);
    }

    public Concept semanticMeaning() {
        return new ConceptDTO(this.semanticMeaningPublicId);
    }

    @Override
    @Marshaler
    public void marshal(TinkarOutput out) {
        this.stamp.marshal(out);
        out.putPublicId(this.semanticPurposePublicId);
        out.putPublicId(this.semanticMeaningPublicId);
        out.writeFieldDefinitionList(this.fieldDefinitionDTOS);
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{PatternVersionDTO.class, "publicId;stamp;semanticPurposePublicId;semanticMeaningPublicId;fieldDefinitionDTOS", "publicId", "stamp", "semanticPurposePublicId", "semanticMeaningPublicId", "fieldDefinitionDTOS"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{PatternVersionDTO.class, "publicId;stamp;semanticPurposePublicId;semanticMeaningPublicId;fieldDefinitionDTOS", "publicId", "stamp", "semanticPurposePublicId", "semanticMeaningPublicId", "fieldDefinitionDTOS"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{PatternVersionDTO.class, "publicId;stamp;semanticPurposePublicId;semanticMeaningPublicId;fieldDefinitionDTOS", "publicId", "stamp", "semanticPurposePublicId", "semanticMeaningPublicId", "fieldDefinitionDTOS"}, this, o);
    }

    public PublicId publicId() {
        return this.publicId;
    }

    public StampDTO stamp() {
        return this.stamp;
    }

    public PublicId semanticPurposePublicId() {
        return this.semanticPurposePublicId;
    }

    public PublicId semanticMeaningPublicId() {
        return this.semanticMeaningPublicId;
    }

    public ImmutableList<FieldDefinitionDTO> fieldDefinitionDTOS() {
        return this.fieldDefinitionDTOS;
    }
}

