/*
 * Decompiled with CFR 0.152.
 */
package dev.ikm.tinkar.dto;

import dev.ikm.tinkar.common.id.PublicId;
import dev.ikm.tinkar.dto.FieldDefinitionDTO;
import dev.ikm.tinkar.dto.PatternVersionDTO;
import dev.ikm.tinkar.dto.StampDTO;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.eclipse.collections.api.list.ImmutableList;

public class PatternVersionDTOBuilder {
    private PublicId publicId;
    private StampDTO stamp;
    private PublicId semanticPurposePublicId;
    private PublicId semanticMeaningPublicId;
    private ImmutableList<FieldDefinitionDTO> fieldDefinitionDTOS;

    private PatternVersionDTOBuilder() {
    }

    private PatternVersionDTOBuilder(PublicId publicId, StampDTO stamp, PublicId semanticPurposePublicId, PublicId semanticMeaningPublicId, ImmutableList<FieldDefinitionDTO> fieldDefinitionDTOS) {
        this.publicId = publicId;
        this.stamp = stamp;
        this.semanticPurposePublicId = semanticPurposePublicId;
        this.semanticMeaningPublicId = semanticMeaningPublicId;
        this.fieldDefinitionDTOS = fieldDefinitionDTOS;
    }

    public static PatternVersionDTO PatternVersionDTO(PublicId publicId, StampDTO stamp, PublicId semanticPurposePublicId, PublicId semanticMeaningPublicId, ImmutableList<FieldDefinitionDTO> fieldDefinitionDTOS) {
        return new PatternVersionDTO(publicId, stamp, semanticPurposePublicId, semanticMeaningPublicId, fieldDefinitionDTOS);
    }

    public static PatternVersionDTOBuilder builder() {
        return new PatternVersionDTOBuilder();
    }

    public static PatternVersionDTOBuilder builder(PatternVersionDTO from) {
        return new PatternVersionDTOBuilder(from.publicId(), from.stamp(), from.semanticPurposePublicId(), from.semanticMeaningPublicId(), from.fieldDefinitionDTOS());
    }

    public static With from(PatternVersionDTO from) {
        return new _FromWith(from);
    }

    public static Stream<Map.Entry<String, Object>> stream(PatternVersionDTO record) {
        return Stream.of(new AbstractMap.SimpleImmutableEntry<String, PublicId>("publicId", record.publicId()), new AbstractMap.SimpleImmutableEntry<String, StampDTO>("stamp", record.stamp()), new AbstractMap.SimpleImmutableEntry<String, PublicId>("semanticPurposePublicId", record.semanticPurposePublicId()), new AbstractMap.SimpleImmutableEntry<String, PublicId>("semanticMeaningPublicId", record.semanticMeaningPublicId()), new AbstractMap.SimpleImmutableEntry<String, ImmutableList<FieldDefinitionDTO>>("fieldDefinitionDTOS", record.fieldDefinitionDTOS()));
    }

    public PatternVersionDTO build() {
        return new PatternVersionDTO(this.publicId, this.stamp, this.semanticPurposePublicId, this.semanticMeaningPublicId, this.fieldDefinitionDTOS);
    }

    public String toString() {
        return "PatternVersionDTOBuilder[publicId=" + String.valueOf(this.publicId) + ", stamp=" + String.valueOf(this.stamp) + ", semanticPurposePublicId=" + String.valueOf(this.semanticPurposePublicId) + ", semanticMeaningPublicId=" + String.valueOf(this.semanticMeaningPublicId) + ", fieldDefinitionDTOS=" + String.valueOf(this.fieldDefinitionDTOS) + "]";
    }

    public int hashCode() {
        return Objects.hash(this.publicId, this.stamp, this.semanticPurposePublicId, this.semanticMeaningPublicId, this.fieldDefinitionDTOS);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof PatternVersionDTOBuilder)) return false;
        PatternVersionDTOBuilder r = (PatternVersionDTOBuilder)o;
        if (!Objects.equals(this.publicId, r.publicId)) return false;
        if (!Objects.equals(this.stamp, r.stamp)) return false;
        if (!Objects.equals(this.semanticPurposePublicId, r.semanticPurposePublicId)) return false;
        if (!Objects.equals(this.semanticMeaningPublicId, r.semanticMeaningPublicId)) return false;
        if (!Objects.equals(this.fieldDefinitionDTOS, r.fieldDefinitionDTOS)) return false;
        return true;
    }

    public PatternVersionDTOBuilder publicId(PublicId publicId) {
        this.publicId = publicId;
        return this;
    }

    public PublicId publicId() {
        return this.publicId;
    }

    public PatternVersionDTOBuilder stamp(StampDTO stamp) {
        this.stamp = stamp;
        return this;
    }

    public StampDTO stamp() {
        return this.stamp;
    }

    public PatternVersionDTOBuilder semanticPurposePublicId(PublicId semanticPurposePublicId) {
        this.semanticPurposePublicId = semanticPurposePublicId;
        return this;
    }

    public PublicId semanticPurposePublicId() {
        return this.semanticPurposePublicId;
    }

    public PatternVersionDTOBuilder semanticMeaningPublicId(PublicId semanticMeaningPublicId) {
        this.semanticMeaningPublicId = semanticMeaningPublicId;
        return this;
    }

    public PublicId semanticMeaningPublicId() {
        return this.semanticMeaningPublicId;
    }

    public PatternVersionDTOBuilder fieldDefinitionDTOS(ImmutableList<FieldDefinitionDTO> fieldDefinitionDTOS) {
        this.fieldDefinitionDTOS = fieldDefinitionDTOS;
        return this;
    }

    public ImmutableList<FieldDefinitionDTO> fieldDefinitionDTOS() {
        return this.fieldDefinitionDTOS;
    }

    private static final class _FromWith
    implements With {
        private final PatternVersionDTO from;

        private _FromWith(PatternVersionDTO from) {
            this.from = from;
        }

        @Override
        public PublicId publicId() {
            return this.from.publicId();
        }

        @Override
        public StampDTO stamp() {
            return this.from.stamp();
        }

        @Override
        public PublicId semanticPurposePublicId() {
            return this.from.semanticPurposePublicId();
        }

        @Override
        public PublicId semanticMeaningPublicId() {
            return this.from.semanticMeaningPublicId();
        }

        @Override
        public ImmutableList<FieldDefinitionDTO> fieldDefinitionDTOS() {
            return this.from.fieldDefinitionDTOS();
        }
    }

    public static interface With {
        public PublicId publicId();

        public StampDTO stamp();

        public PublicId semanticPurposePublicId();

        public PublicId semanticMeaningPublicId();

        public ImmutableList<FieldDefinitionDTO> fieldDefinitionDTOS();

        default public PatternVersionDTOBuilder with() {
            return new PatternVersionDTOBuilder(this.publicId(), this.stamp(), this.semanticPurposePublicId(), this.semanticMeaningPublicId(), this.fieldDefinitionDTOS());
        }

        default public PatternVersionDTO with(Consumer<PatternVersionDTOBuilder> consumer) {
            PatternVersionDTOBuilder builder = this.with();
            consumer.accept(builder);
            return builder.build();
        }

        default public PatternVersionDTO withPublicId(PublicId publicId) {
            return new PatternVersionDTO(publicId, this.stamp(), this.semanticPurposePublicId(), this.semanticMeaningPublicId(), this.fieldDefinitionDTOS());
        }

        default public PatternVersionDTO withStamp(StampDTO stamp) {
            return new PatternVersionDTO(this.publicId(), stamp, this.semanticPurposePublicId(), this.semanticMeaningPublicId(), this.fieldDefinitionDTOS());
        }

        default public PatternVersionDTO withSemanticPurposePublicId(PublicId semanticPurposePublicId) {
            return new PatternVersionDTO(this.publicId(), this.stamp(), semanticPurposePublicId, this.semanticMeaningPublicId(), this.fieldDefinitionDTOS());
        }

        default public PatternVersionDTO withSemanticMeaningPublicId(PublicId semanticMeaningPublicId) {
            return new PatternVersionDTO(this.publicId(), this.stamp(), this.semanticPurposePublicId(), semanticMeaningPublicId, this.fieldDefinitionDTOS());
        }

        default public PatternVersionDTO withFieldDefinitionDTOS(ImmutableList<FieldDefinitionDTO> fieldDefinitionDTOS) {
            return new PatternVersionDTO(this.publicId(), this.stamp(), this.semanticPurposePublicId(), this.semanticMeaningPublicId(), fieldDefinitionDTOS);
        }
    }
}

