/*
 * Decompiled with CFR 0.152.
 */
package dev.ikm.tinkar.dto;

import dev.ikm.tinkar.common.id.PublicId;
import dev.ikm.tinkar.component.Component;
import dev.ikm.tinkar.component.Pattern;
import dev.ikm.tinkar.component.SemanticChronology;
import dev.ikm.tinkar.component.SemanticVersion;
import dev.ikm.tinkar.dto.ComponentDTO;
import dev.ikm.tinkar.dto.DTO;
import dev.ikm.tinkar.dto.PatternDTO;
import dev.ikm.tinkar.dto.SemanticVersionDTO;
import dev.ikm.tinkar.dto.binary.Marshalable;
import dev.ikm.tinkar.dto.binary.Marshaler;
import dev.ikm.tinkar.dto.binary.TinkarInput;
import dev.ikm.tinkar.dto.binary.TinkarOutput;
import dev.ikm.tinkar.dto.binary.Unmarshaler;
import java.io.Serializable;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.factory.Lists;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.api.list.MutableList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public record SemanticChronologyDTO(PublicId publicId, PublicId patternPublicId, PublicId referencedComponentPublicId, ImmutableList<SemanticVersionDTO> semanticVersions) implements SemanticChronology<SemanticVersionDTO>,
DTO,
Marshalable
{
    private static final Logger LOG = LoggerFactory.getLogger(SemanticChronologyDTO.class);
    private static final int localMarshalVersion = 3;

    public SemanticChronologyDTO(PublicId componentUuids, Pattern patternForSemantic, Component referencedComponent, ImmutableList<SemanticVersionDTO> semanticVersions) {
        this(componentUuids, patternForSemantic.publicId(), referencedComponent.publicId(), semanticVersions);
    }

    public static SemanticChronologyDTO make(SemanticChronology<? extends SemanticVersion> semanticChronology) {
        MutableList changeSetVersions = Lists.mutable.ofInitialCapacity(semanticChronology.versions().size());
        for (SemanticVersion semanticVersion : semanticChronology.versions()) {
            changeSetVersions.add((Object)SemanticVersionDTO.make(semanticVersion));
        }
        return new SemanticChronologyDTO(semanticChronology.publicId(), semanticChronology.pattern(), semanticChronology.referencedComponent(), (ImmutableList<SemanticVersionDTO>)changeSetVersions.toImmutable());
    }

    @Unmarshaler
    public static SemanticChronologyDTO make(TinkarInput in) {
        if (3 == in.getTinkerFormatVersion()) {
            PublicId componentUuids = in.getPublicId();
            PublicId patternUuids = in.getPublicId();
            PublicId referencedComponentUuids = in.getPublicId();
            return new SemanticChronologyDTO(componentUuids, patternUuids, referencedComponentUuids, in.readSemanticVersionList(componentUuids, patternUuids, referencedComponentUuids));
        }
        throw new UnsupportedOperationException("Unsupported version: " + in.getTinkerFormatVersion());
    }

    public Component referencedComponent() {
        return new ComponentDTO(this.referencedComponentPublicId);
    }

    public Pattern pattern() {
        return new PatternDTO(this.patternPublicId);
    }

    public ImmutableList<SemanticVersionDTO> versions() {
        return this.semanticVersions.collect((Function & Serializable)semanticVersionDTO -> semanticVersionDTO);
    }

    @Override
    @Marshaler
    public void marshal(TinkarOutput out) {
        out.putPublicId(this.publicId());
        out.putPublicId(this.patternPublicId);
        out.putPublicId(this.referencedComponentPublicId);
        out.writeSemanticVersionList(this.semanticVersions);
    }
}

