/*
 * Decompiled with CFR 0.152.
 */
package dev.ikm.tinkar.dto;

import dev.ikm.tinkar.common.id.PublicId;
import dev.ikm.tinkar.dto.SemanticChronologyDTO;
import dev.ikm.tinkar.dto.SemanticVersionDTO;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.eclipse.collections.api.list.ImmutableList;

public class SemanticChronologyDTOBuilder {
    private PublicId publicId;
    private PublicId patternPublicId;
    private PublicId referencedComponentPublicId;
    private ImmutableList<SemanticVersionDTO> semanticVersions;

    private SemanticChronologyDTOBuilder() {
    }

    private SemanticChronologyDTOBuilder(PublicId publicId, PublicId patternPublicId, PublicId referencedComponentPublicId, ImmutableList<SemanticVersionDTO> semanticVersions) {
        this.publicId = publicId;
        this.patternPublicId = patternPublicId;
        this.referencedComponentPublicId = referencedComponentPublicId;
        this.semanticVersions = semanticVersions;
    }

    public static SemanticChronologyDTO SemanticChronologyDTO(PublicId publicId, PublicId patternPublicId, PublicId referencedComponentPublicId, ImmutableList<SemanticVersionDTO> semanticVersions) {
        return new SemanticChronologyDTO(publicId, patternPublicId, referencedComponentPublicId, semanticVersions);
    }

    public static SemanticChronologyDTOBuilder builder() {
        return new SemanticChronologyDTOBuilder();
    }

    public static SemanticChronologyDTOBuilder builder(SemanticChronologyDTO from) {
        return new SemanticChronologyDTOBuilder(from.publicId(), from.patternPublicId(), from.referencedComponentPublicId(), from.semanticVersions());
    }

    public static With from(SemanticChronologyDTO from) {
        return new _FromWith(from);
    }

    public static Stream<Map.Entry<String, Object>> stream(SemanticChronologyDTO record) {
        return Stream.of(new AbstractMap.SimpleImmutableEntry<String, PublicId>("publicId", record.publicId()), new AbstractMap.SimpleImmutableEntry<String, PublicId>("patternPublicId", record.patternPublicId()), new AbstractMap.SimpleImmutableEntry<String, PublicId>("referencedComponentPublicId", record.referencedComponentPublicId()), new AbstractMap.SimpleImmutableEntry<String, ImmutableList<SemanticVersionDTO>>("semanticVersions", record.semanticVersions()));
    }

    public SemanticChronologyDTO build() {
        return new SemanticChronologyDTO(this.publicId, this.patternPublicId, this.referencedComponentPublicId, this.semanticVersions);
    }

    public String toString() {
        return "SemanticChronologyDTOBuilder[publicId=" + String.valueOf(this.publicId) + ", patternPublicId=" + String.valueOf(this.patternPublicId) + ", referencedComponentPublicId=" + String.valueOf(this.referencedComponentPublicId) + ", semanticVersions=" + String.valueOf(this.semanticVersions) + "]";
    }

    public int hashCode() {
        return Objects.hash(this.publicId, this.patternPublicId, this.referencedComponentPublicId, this.semanticVersions);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof SemanticChronologyDTOBuilder)) return false;
        SemanticChronologyDTOBuilder r = (SemanticChronologyDTOBuilder)o;
        if (!Objects.equals(this.publicId, r.publicId)) return false;
        if (!Objects.equals(this.patternPublicId, r.patternPublicId)) return false;
        if (!Objects.equals(this.referencedComponentPublicId, r.referencedComponentPublicId)) return false;
        if (!Objects.equals(this.semanticVersions, r.semanticVersions)) return false;
        return true;
    }

    public SemanticChronologyDTOBuilder publicId(PublicId publicId) {
        this.publicId = publicId;
        return this;
    }

    public PublicId publicId() {
        return this.publicId;
    }

    public SemanticChronologyDTOBuilder patternPublicId(PublicId patternPublicId) {
        this.patternPublicId = patternPublicId;
        return this;
    }

    public PublicId patternPublicId() {
        return this.patternPublicId;
    }

    public SemanticChronologyDTOBuilder referencedComponentPublicId(PublicId referencedComponentPublicId) {
        this.referencedComponentPublicId = referencedComponentPublicId;
        return this;
    }

    public PublicId referencedComponentPublicId() {
        return this.referencedComponentPublicId;
    }

    public SemanticChronologyDTOBuilder semanticVersions(ImmutableList<SemanticVersionDTO> semanticVersions) {
        this.semanticVersions = semanticVersions;
        return this;
    }

    public ImmutableList<SemanticVersionDTO> semanticVersions() {
        return this.semanticVersions;
    }

    private static final class _FromWith
    implements With {
        private final SemanticChronologyDTO from;

        private _FromWith(SemanticChronologyDTO from) {
            this.from = from;
        }

        @Override
        public PublicId publicId() {
            return this.from.publicId();
        }

        @Override
        public PublicId patternPublicId() {
            return this.from.patternPublicId();
        }

        @Override
        public PublicId referencedComponentPublicId() {
            return this.from.referencedComponentPublicId();
        }

        @Override
        public ImmutableList<SemanticVersionDTO> semanticVersions() {
            return this.from.semanticVersions();
        }
    }

    public static interface With {
        public PublicId publicId();

        public PublicId patternPublicId();

        public PublicId referencedComponentPublicId();

        public ImmutableList<SemanticVersionDTO> semanticVersions();

        default public SemanticChronologyDTOBuilder with() {
            return new SemanticChronologyDTOBuilder(this.publicId(), this.patternPublicId(), this.referencedComponentPublicId(), this.semanticVersions());
        }

        default public SemanticChronologyDTO with(Consumer<SemanticChronologyDTOBuilder> consumer) {
            SemanticChronologyDTOBuilder builder = this.with();
            consumer.accept(builder);
            return builder.build();
        }

        default public SemanticChronologyDTO withPublicId(PublicId publicId) {
            return new SemanticChronologyDTO(publicId, this.patternPublicId(), this.referencedComponentPublicId(), this.semanticVersions());
        }

        default public SemanticChronologyDTO withPatternPublicId(PublicId patternPublicId) {
            return new SemanticChronologyDTO(this.publicId(), patternPublicId, this.referencedComponentPublicId(), this.semanticVersions());
        }

        default public SemanticChronologyDTO withReferencedComponentPublicId(PublicId referencedComponentPublicId) {
            return new SemanticChronologyDTO(this.publicId(), this.patternPublicId(), referencedComponentPublicId, this.semanticVersions());
        }

        default public SemanticChronologyDTO withSemanticVersions(ImmutableList<SemanticVersionDTO> semanticVersions) {
            return new SemanticChronologyDTO(this.publicId(), this.patternPublicId(), this.referencedComponentPublicId(), semanticVersions);
        }
    }
}

