/*
 * Decompiled with CFR 0.152.
 */
package dev.ikm.tinkar.dto;

import dev.ikm.tinkar.common.id.PublicId;
import dev.ikm.tinkar.dto.SemanticDTO;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Stream;

public class SemanticDTOBuilder {
    private PublicId publicId;

    private SemanticDTOBuilder() {
    }

    private SemanticDTOBuilder(PublicId publicId) {
        this.publicId = publicId;
    }

    public static SemanticDTO SemanticDTO(PublicId publicId) {
        return new SemanticDTO(publicId);
    }

    public static SemanticDTOBuilder builder() {
        return new SemanticDTOBuilder();
    }

    public static SemanticDTOBuilder builder(SemanticDTO from) {
        return new SemanticDTOBuilder(from.publicId());
    }

    public static With from(SemanticDTO from) {
        return new _FromWith(from);
    }

    public static Stream<Map.Entry<String, Object>> stream(SemanticDTO record) {
        return Stream.of(new AbstractMap.SimpleImmutableEntry<String, PublicId>("publicId", record.publicId()));
    }

    public SemanticDTO build() {
        return new SemanticDTO(this.publicId);
    }

    public String toString() {
        return "SemanticDTOBuilder[publicId=" + String.valueOf(this.publicId) + "]";
    }

    public int hashCode() {
        return Objects.hash(this.publicId);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof SemanticDTOBuilder)) return false;
        SemanticDTOBuilder r = (SemanticDTOBuilder)o;
        if (!Objects.equals(this.publicId, r.publicId)) return false;
        return true;
    }

    public SemanticDTOBuilder publicId(PublicId publicId) {
        this.publicId = publicId;
        return this;
    }

    public PublicId publicId() {
        return this.publicId;
    }

    private static final class _FromWith
    implements With {
        private final SemanticDTO from;

        private _FromWith(SemanticDTO from) {
            this.from = from;
        }

        @Override
        public PublicId publicId() {
            return this.from.publicId();
        }
    }

    public static interface With {
        public PublicId publicId();

        default public SemanticDTOBuilder with() {
            return new SemanticDTOBuilder(this.publicId());
        }

        default public SemanticDTO with(Consumer<SemanticDTOBuilder> consumer) {
            SemanticDTOBuilder builder = this.with();
            consumer.accept(builder);
            return builder.build();
        }

        default public SemanticDTO withPublicId(PublicId publicId) {
            return new SemanticDTO(publicId);
        }
    }
}

