/*
 * Decompiled with CFR 0.152.
 */
package dev.ikm.tinkar.dto;

import dev.ikm.tinkar.common.id.PublicId;
import dev.ikm.tinkar.component.Component;
import dev.ikm.tinkar.component.Concept;
import dev.ikm.tinkar.component.Pattern;
import dev.ikm.tinkar.component.Semantic;
import dev.ikm.tinkar.component.SemanticVersion;
import dev.ikm.tinkar.component.Stamp;
import dev.ikm.tinkar.dto.ComponentDTO;
import dev.ikm.tinkar.dto.ConceptDTO;
import dev.ikm.tinkar.dto.PatternDTO;
import dev.ikm.tinkar.dto.SemanticDTO;
import dev.ikm.tinkar.dto.StampDTO;
import dev.ikm.tinkar.dto.binary.Marshalable;
import dev.ikm.tinkar.dto.binary.Marshaler;
import dev.ikm.tinkar.dto.binary.SemanticVersionUnmarshaler;
import dev.ikm.tinkar.dto.binary.TinkarInput;
import dev.ikm.tinkar.dto.binary.TinkarOutput;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.time.Instant;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.factory.Lists;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.api.list.MutableList;

public final class SemanticVersionDTO
extends Record
implements SemanticVersion,
Marshalable {
    private final PublicId publicId;
    private final StampDTO stamp;
    private final ImmutableList<Object> fieldValues;
    private static final int localMarshalVersion = 3;

    public SemanticVersionDTO(PublicId publicId, Stamp stamp, ImmutableList<Object> fields) {
        this(publicId, StampDTO.make(stamp), fields);
    }

    public SemanticVersionDTO(PublicId publicId, StampDTO stamp, ImmutableList<Object> fieldValues) {
        this.publicId = publicId;
        this.stamp = stamp;
        this.fieldValues = fieldValues;
    }

    public static SemanticVersionDTO make(SemanticVersion semanticVersion) {
        MutableList convertedFields = Lists.mutable.empty();
        semanticVersion.fieldValues().forEach((Procedure & Serializable)objectToConvert -> {
            if (objectToConvert instanceof Concept) {
                Concept concept = (Concept)objectToConvert;
                convertedFields.add((Object)new ConceptDTO(concept.publicId()));
            } else if (objectToConvert instanceof Pattern) {
                Pattern pattern = (Pattern)objectToConvert;
                convertedFields.add((Object)new PatternDTO(pattern.publicId()));
            } else if (objectToConvert instanceof Semantic) {
                Semantic semantic = (Semantic)objectToConvert;
                convertedFields.add((Object)new SemanticDTO(semantic.publicId()));
            } else if (objectToConvert instanceof Component) {
                Component component = (Component)objectToConvert;
                convertedFields.add((Object)new ComponentDTO(component.publicId()));
            } else if (objectToConvert instanceof Number) {
                Number number = (Number)objectToConvert;
                if (number instanceof Long) {
                    convertedFields.add((Object)number.intValue());
                } else if (number instanceof Double) {
                    convertedFields.add((Object)Float.valueOf(number.floatValue()));
                } else {
                    convertedFields.add((Object)number);
                }
            } else if (objectToConvert instanceof String) {
                convertedFields.add(objectToConvert);
            } else if (objectToConvert instanceof Instant) {
                convertedFields.add(objectToConvert);
            } else {
                throw new UnsupportedOperationException("Can't convert:\n  " + String.valueOf(objectToConvert) + "\nin\n  " + String.valueOf(semanticVersion));
            }
        });
        return new SemanticVersionDTO(semanticVersion.publicId(), StampDTO.make(semanticVersion.stamp()), (ImmutableList<Object>)convertedFields.toImmutable());
    }

    @SemanticVersionUnmarshaler
    public static SemanticVersionDTO make(TinkarInput in, PublicId componentPublicId) {
        if (3 == in.getTinkerFormatVersion()) {
            return new SemanticVersionDTO(componentPublicId, StampDTO.make(in), in.readImmutableObjectList());
        }
        throw new UnsupportedOperationException("Unsupported version: " + in.getTinkerFormatVersion());
    }

    @Override
    @Marshaler
    public void marshal(TinkarOutput out) {
        this.stamp.marshal(out);
        out.writeObjectList(this.fieldValues);
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{SemanticVersionDTO.class, "publicId;stamp;fieldValues", "publicId", "stamp", "fieldValues"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{SemanticVersionDTO.class, "publicId;stamp;fieldValues", "publicId", "stamp", "fieldValues"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{SemanticVersionDTO.class, "publicId;stamp;fieldValues", "publicId", "stamp", "fieldValues"}, this, o);
    }

    public PublicId publicId() {
        return this.publicId;
    }

    public StampDTO stamp() {
        return this.stamp;
    }

    public ImmutableList<Object> fieldValues() {
        return this.fieldValues;
    }
}

